/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.net.URI;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildValidator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.joda.time.DateTime;

public abstract class RpkiSignedObject
implements CertificateRepositoryObject {
    private static final long serialVersionUID = 1L;
    public static final String RSA_ENCRYPTION_OID = CMSSignedDataGenerator.ENCRYPTION_RSA;
    public static final String SHA256WITHRSA_ENCRYPTION_OID = PKCSObjectIdentifiers.sha256WithRSAEncryption.getId();
    public static final String DIGEST_ALGORITHM_OID = CMSSignedDataGenerator.DIGEST_SHA256;
    private byte[] encoded;
    private X509ResourceCertificate certificate;
    private String oid;
    private DateTime signingTime;

    protected RpkiSignedObject(RpkiSignedObjectInfo cmsObjectData) {
        this(cmsObjectData.getEncoded(), cmsObjectData.getCertificate(), cmsObjectData.getContentType(), cmsObjectData.getSigningTime());
    }

    protected RpkiSignedObject(byte[] encoded, X509ResourceCertificate certificate, ASN1ObjectIdentifier oid, DateTime signingTime) {
        this.encoded = encoded;
        this.certificate = certificate;
        this.oid = oid.getId();
        this.signingTime = signingTime;
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }

    public DateTime getSigningTime() {
        return this.signingTime;
    }

    public ASN1ObjectIdentifier getContentType() {
        return new ASN1ObjectIdentifier(this.oid);
    }

    public X509ResourceCertificate getCertificate() {
        return this.certificate;
    }

    public boolean signedBy(X509ResourceCertificate certificate) {
        return this.certificate.equals(certificate);
    }

    public ValidityPeriod getValidityPeriod() {
        return this.certificate.getValidityPeriod();
    }

    public DateTime getNotValidBefore() {
        return this.certificate.getValidityPeriod().getNotValidBefore();
    }

    public DateTime getNotValidAfter() {
        return this.certificate.getValidityPeriod().getNotValidAfter();
    }

    public X500Principal getCertificateIssuer() {
        return this.getCertificate().getIssuer();
    }

    public X500Principal getCertificateSubject() {
        return this.getCertificate().getSubject();
    }

    @Override
    public URI getCrlUri() {
        return this.getCertificate().findFirstRsyncCrlDistributionPoint();
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, CrlLocator crlLocator, ValidationOptions options, ValidationResult result) {
        ValidationLocation savedCurrentLocation = result.getCurrentLocation();
        result.setLocation(new ValidationLocation(this.getCrlUri()));
        X509Crl crl = crlLocator.getCrl(this.getCrlUri(), context, result);
        result.setLocation(savedCurrentLocation);
        result.rejectIfNull(crl, "objects.crl.valid", this.getCrlUri().toString());
        if (crl == null) {
            return;
        }
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(options, result, context.getCertificate(), crl, context.getResources());
        validator.validate(location, this.getCertificate());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RpkiSignedObject other = (RpkiSignedObject)obj;
        return Arrays.equals(this.getEncoded(), other.getEncoded());
    }
}

