/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.xml.converters.RoaCmsConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoaCmsConverterTest {
    private XStream xStream;
    private RoaCmsConverter subject;
    private String expectedXmlRegEx = "<net\\.ripe\\..*\\.RoaCms>\n  <encoded>[^<]*</encoded>\n</net\\.ripe\\..*\\.RoaCms>";

    @Before
    public void setUp() {
        this.subject = new RoaCmsConverter();
        this.xStream = new XStream();
        this.xStream.registerConverter((Converter)this.subject);
    }

    @Test
    public void shouldSupportResourceCertificate() {
        Assert.assertTrue((boolean)this.subject.canConvert(RoaCms.class));
    }

    @Test
    public void shouldOnlyUseEncodedWhenSerializingRoa() {
        RoaCms roa = RoaCmsTest.getRoaCms();
        String xml = this.xStream.toXML((Object)roa);
        Assert.assertTrue((boolean)Pattern.matches(this.expectedXmlRegEx, xml));
    }

    @Test
    public void shouldDoRoundTripSerializeAndDesirializeRoa() {
        RoaCms roa = RoaCmsTest.getRoaCms();
        String xml = this.xStream.toXML((Object)roa);
        RoaCms processedRoa = (RoaCms)this.xStream.fromXML(xml);
        Assert.assertEquals((Object)roa, (Object)processedRoa);
    }
}

