/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.util.Arrays;
import net.ripe.rpki.commons.rsync.Rsync;
import org.junit.Assert;
import org.junit.Test;

public class RsyncTest {
    @Test
    public void shouldExecuteCommand() {
        Rsync rsync = new Rsync();
        rsync.addOptions(new String[]{"--version"});
        Assert.assertFalse((boolean)rsync.isCompleted());
        Assert.assertNull((Object)rsync.getException());
        Assert.assertNull((Object)rsync.getErrorLines());
        Assert.assertNull((Object)rsync.getOutputLines());
        int exitStatus = rsync.execute();
        Assert.assertTrue((exitStatus == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rsync.isCompleted());
        Assert.assertNull((Object)rsync.getException());
        Assert.assertNotNull((Object)rsync.getErrorLines());
        Assert.assertTrue((rsync.getErrorLines().length == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)rsync.getOutputLines());
        Assert.assertTrue((rsync.getOutputLines().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldMeasureElapsedTime() {
        Rsync rsync = new Rsync();
        rsync.addOptions(new String[]{"--version"});
        rsync.execute();
        Assert.assertTrue((rsync.elapsedTime() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void shouldFailOnInvalidOption() {
        Rsync rsync = new Rsync();
        rsync.addOptions(new String[]{"--invalid_option"});
        rsync.execute();
        Assert.assertTrue((rsync.getExitStatus() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rsync.isCompleted());
        Assert.assertNull((Object)rsync.getException());
        Assert.assertNotNull((Object)rsync.getErrorLines());
        Assert.assertTrue((rsync.getErrorLines().length > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)rsync.getOutputLines());
        Assert.assertTrue((rsync.getOutputLines().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldResetProperly() {
        Rsync rsync = new Rsync();
        rsync.addOptions(Arrays.asList("--version"));
        Assert.assertFalse((boolean)rsync.isCompleted());
        Assert.assertNull((Object)rsync.getException());
        Assert.assertNull((Object)rsync.getErrorLines());
        Assert.assertNull((Object)rsync.getOutputLines());
        int exitStatus = rsync.execute();
        Assert.assertTrue((exitStatus == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rsync.isCompleted());
        Assert.assertNull((Object)rsync.getException());
        Assert.assertNotNull((Object)rsync.getErrorLines());
        Assert.assertTrue((rsync.getErrorLines().length == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)rsync.getOutputLines());
        Assert.assertTrue((rsync.getOutputLines().length > 0 ? 1 : 0) != 0);
        rsync.reset();
        Assert.assertFalse((boolean)rsync.isCompleted());
        Assert.assertNull((Object)rsync.getException());
        Assert.assertNull((Object)rsync.getErrorLines());
        Assert.assertNull((Object)rsync.getOutputLines());
    }
}

