/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class BBNCrlConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Test
    public void shouldParseCrlWith2CrlNumbers() throws IOException {
        boolean hasFailure = this.parseCrl("root/CRL2CRLNums/badCRL2CRLNums.crl");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldParseCrlWithVersion0() throws IOException {
        boolean hasFailure = this.parseCrl("root/CRLVersion0/badCRLVersion0.crl");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldParseCrlWithVersion2() throws IOException {
        boolean hasFailure = this.parseCrl("root/CRLVersion2/badCRLVersion2.crl");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldParseCrlWithWrongSignatureAlgorithmIdInToBeSigned() throws IOException {
        boolean hasFailure = this.parseCrl("root/CRLSigAlgInner/badCRLSigAlgInner.crl");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldParseCrlWithWrongOuterSignatureAlgorithmId() throws IOException {
        boolean hasFailure = this.parseCrl("root/CRLSigAlgOuter/badCRLSigAlgOuter.crl");
        Assert.assertTrue((boolean)hasFailure);
    }

    private boolean parseCrl(String crl) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, crl);
        byte[] encoded = FileUtils.readFileToByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        X509Crl.parseDerEncoded((byte[])encoded, (ValidationResult)result);
        return result.hasFailures();
    }
}

