/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.io.File;
import java.io.IOException;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.rsync.RemoteCertificateFetcher;
import net.ripe.rpki.commons.rsync.Rsync;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoteCertificateFetcherTest {
    private RemoteCertificateFetcher subject;
    private static final String RSYNC_SOME_VALID_SOURCE_PATH_CER = "rsync://some.valid/path.cer";
    private static final String RSYNC_SOME_VALID_SOURCE_PATH_CRL = "rsync://some.valid/path.crl";
    private static final X509ResourceCertificate TEST_CERTIFICATE = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
    private static final X509Crl TEST_CRL = X509CrlTest.createCrl();

    @Before
    public void setUp() {
        this.subject = new RemoteCertificateFetcher();
        this.subject.setRsyncClient((Rsync)new StubbedRsync());
    }

    @Test
    public void shouldGetCertificateFromRemoteUri() {
        X509ResourceCertificate actualCertificate = this.subject.getRemoteResourceCertificate(RSYNC_SOME_VALID_SOURCE_PATH_CER);
        Assert.assertNotNull((Object)actualCertificate);
        Assert.assertEquals((Object)TEST_CERTIFICATE, (Object)actualCertificate);
    }

    @Test
    public void shouldGetCrlFromRemoteUri() {
        X509Crl actualCrl = this.subject.getRemoteCrl(RSYNC_SOME_VALID_SOURCE_PATH_CRL);
        Assert.assertNotNull((Object)actualCrl);
        Assert.assertEquals((Object)TEST_CRL, (Object)actualCrl);
    }

    private static final class StubbedRsync
    extends Rsync {
        private StubbedRsync() {
        }

        public int execute() {
            try {
                byte[] encoded = null;
                if (this.getSource().equals(RemoteCertificateFetcherTest.RSYNC_SOME_VALID_SOURCE_PATH_CER)) {
                    encoded = TEST_CERTIFICATE.getEncoded();
                }
                if (this.getSource().equals(RemoteCertificateFetcherTest.RSYNC_SOME_VALID_SOURCE_PATH_CRL)) {
                    encoded = TEST_CRL.getEncoded();
                }
                FileUtils.writeByteArrayToFile((File)new File(this.getDestination()), (byte[])encoded);
                return 0;
            }
            catch (IOException e) {
                return 1;
            }
        }
    }
}

