/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentity;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentitySerializer;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import org.junit.Assert;
import org.junit.Test;

public class ChildIdentitySerializerTest {
    static final String exampleChildIdXml = "<ns0:identity xmlns:ns0=\"http://www.hactrn.net/uris/rpki/myrpki/\" handle=\"Bob\" version=\"2\">\n<ns0:bpki_ta>\nMIIDIDCCAgigAwIBAgIBATANBgkqhkiG9w0BAQsFADApMScwJQYDVQQDEx5Cb2Ig\nQlBLSSBSZXNvdXJjZSBUcnVzdCBBbmNob3IwHhcNMTEwNzAxMDQwNzIzWhcNMTIw\nNjMwMDQwNzIzWjApMScwJQYDVQQDEx5Cb2IgQlBLSSBSZXNvdXJjZSBUcnVzdCBB\nbmNob3IwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDEk1f7cVzHu3r/\nfJ5gkBxnWMNJ1CP0kPtfP8oFOEVVH1lX0MHuFKhdKA4WCkGkeFtGb/4T/nGgsD+z\nexZid6RR8zjHkwMLvAl0x6wdKa46XJbFu+wTSu+vlowVY9rGzH+ttv4Fj6E2Y3DG\n983/dVNJfXl00+Ts7rlvVcn9lI5dWvzsLoUOdhD4hsyKp53k8i4HexiD+0ugPeh9\n4PKiyZOuMjSRNQSBUA3ElqJSRZz7nWvs/j6zhwHdFa+lN56575Mc5mrwr+KePwW5\nDLt3izYpjwKffVuxUKPTrhvnOOg5kBBv0ihync21LSLds6jusxaMYUwUElO8KQyn\nNUAeGPd/AgMBAAGjUzBRMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFORFOC3G\nPjYKn7V1/BJHDmZ4W7J+MB8GA1UdIwQYMBaAFORFOC3GPjYKn7V1/BJHDmZ4W7J+\nMA0GCSqGSIb3DQEBCwUAA4IBAQBqsP4ENtWTkNdsekYB+4hO/Afq20Ho0W8lyTkM\nJO1UFDt/dzFAmTT4uM7pmwuQfqmCYjNDWon8nsdFno4tA0is3aiq6yIMAYzBE5ub\nbnJMxldqLoWuakco1wYa3kZFzWPwecxgJ4ZlqTPGu0Loyjibt25IE9MfixyWDw+D\nMhyfonLLgFb5jz7A3BTE63vlTp359uDbFb1nRdyoT31s3FUBK8jF4B5pWzPiLdct\nbOMVjYUBs8aFC3fDXyGSr/RcjE4OOZQyTkYZn8zCPUJ4KqOPAUV9u9jx2FPvOcA3\n1BjcmhYHqott+cnK1ITOjLe9EKejRZv/7/BFsmpzm2Zbq1KA\n</ns0:bpki_ta>\n</ns0:identity>\n";

    @Test
    public void shouldDeserializeXml() {
        ChildIdentitySerializer serializer = new ChildIdentitySerializer();
        ChildIdentity childId = serializer.deserialize(exampleChildIdXml);
        Assert.assertEquals((Object)"Bob", (Object)childId.getHandle());
        ProvisioningIdentityCertificate identityCertificate = childId.getIdentityCertificate();
        Assert.assertEquals((Object)new X500Principal("CN=Bob BPKI Resource Trust Anchor"), (Object)identityCertificate.getSubject());
    }

    @Test
    public void shouldDoDaRoundTripThang() {
        ChildIdentity childIdentity = new ChildIdentity(ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        ChildIdentitySerializer serializer = new ChildIdentitySerializer();
        String xml = serializer.serialize(childIdentity);
        ChildIdentity deserializedChildId = serializer.deserialize(xml);
        Assert.assertEquals((Object)childIdentity, (Object)deserializedChildId);
    }
}

