/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BBNCertificateConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Ignore(value="Early ripe ncc ta certificates have crldp set")
    @Test
    public void shouldRejectSelfSignedCertificateWithCRLDP() throws IOException {
        boolean hasFailure = this.parseCertificate("badRootBadCRLDP.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithReasonFieldNotOmitted() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPReasons.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithCrlIssuer() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPCrlIssuer.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    private boolean parseCertificate(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = FileUtils.readFileToByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new X509ResourceCertificateParser().parse(result, encoded);
        return result.hasFailures();
    }
}

