/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JavaUtilTimestampConverter
implements SingleValueConverter {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    public boolean canConvert(Class type) {
        return Timestamp.class.equals((Object)type);
    }

    public Object fromString(String s) {
        return new Timestamp(FORMATTER.parseDateTime(s).getMillis());
    }

    public String toString(Object datetime) {
        return FORMATTER.print((ReadableInstant)new DateTime(datetime));
    }
}

