/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlValidator;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCertificateValidator;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;

public class ProvisioningCmsObjectValidator {
    private ValidationOptions options;
    private ProvisioningCmsObject cmsObject;
    private ProvisioningIdentityCertificate identityCertificate;
    private ValidationResult validationResult;
    private ProvisioningCmsCertificate cmsCertificate;
    private X509Crl crl;

    public ProvisioningCmsObjectValidator(ValidationOptions options, ProvisioningCmsObject cmsObject, ProvisioningIdentityCertificate identityCertificate) {
        this.options = options;
        this.cmsObject = cmsObject;
        this.identityCertificate = identityCertificate;
    }

    public void validate(ValidationResult validationResult) {
        this.validationResult = validationResult;
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser(validationResult);
        parser.parseCms("<cms>", this.cmsObject.getEncoded());
        if (parser.getValidationResult().hasFailures()) {
            return;
        }
        this.cmsCertificate = new ProvisioningCmsCertificate(this.cmsObject.getCmsCertificate());
        this.crl = new X509Crl(this.cmsObject.getCrl());
        this.validateCrl();
        this.validateCertificateChain();
    }

    private void validateCrl() {
        X509CrlValidator crlValidator = new X509CrlValidator(new ValidationOptions(), this.validationResult, this.identityCertificate);
        crlValidator.validate("<crl>", this.crl);
    }

    private void validateCertificateChain() {
        this.validateCmsCertificate();
        this.validateIdentityCertificate();
    }

    private void validateCmsCertificate() {
        ProvisioningCertificateValidator validator = new ProvisioningCertificateValidator(this.options, this.validationResult, this.identityCertificate, this.crl);
        validator.validate("<cms-cert>", this.cmsCertificate);
    }

    private void validateIdentityCertificate() {
        ProvisioningCertificateValidator validator = new ProvisioningCertificateValidator(this.options, this.validationResult, this.identityCertificate, this.crl);
        validator.validate("<identity-cert>", this.identityCertificate);
    }
}

