/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.net.URI;
import net.ripe.rpki.commons.crypto.x509cert.GenericRpkiCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import org.apache.commons.lang.Validate;

public class RpkiSignedObjectEeCertificateBuilder
extends GenericRpkiCertificateBuilder {
    private URI cmsPublicationUri;

    public void withCorrespondingCmsPublicationPoint(URI cmsPublicationUri) {
        this.cmsPublicationUri = cmsPublicationUri;
    }

    public X509ResourceCertificate build() {
        this.validateFields();
        X509ResourceCertificateBuilder builder = this.createGenericRpkiCertificateBuilder();
        builder.withCa(false);
        builder.withKeyUsage(128);
        X509CertificateInformationAccessDescriptor[] siaDescriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, this.cmsPublicationUri)};
        builder.withSubjectInformationAccess(siaDescriptors);
        return builder.build();
    }

    @Override
    protected void validateFields() {
        super.validateFields();
        Validate.isTrue((!this.isSelfSigned() ? 1 : 0) != 0, (String)"EE Certificate can not be self-signed (use EE keypair for public and signing the object, sign this cert with parent key pair)");
        Validate.notNull((Object)this.cmsPublicationUri, (String)"CMS Object Publication URI is required");
    }
}

