/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import org.apache.commons.lang.Validate;

public abstract class GenericRpkiCertificateBuilder {
    private PublicKey publicKey;
    private KeyPair signingKeyPair;
    private BigInteger serial;
    private IpResourceSet resources = new IpResourceSet();
    private EnumSet<IpResourceType> inheritedResourceTypes = EnumSet.noneOf(IpResourceType.class);
    private X500Principal subject;
    private X500Principal issuer;
    private ValidityPeriod validityPeriod;
    private URI crlUri;
    private URI parentResourceCertificatePublicationUri;
    private String signatureProvider = "SunRsaSign";

    public void withPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void withSigningKeyPair(KeyPair signingKeyPair) {
        this.signingKeyPair = signingKeyPair;
    }

    public void withSerial(BigInteger serial) {
        this.serial = serial;
    }

    public void withResources(IpResourceSet resources) {
        this.resources = resources;
    }

    public void withInheritedResourceTypes(EnumSet<IpResourceType> resourceTypes) {
        this.inheritedResourceTypes = EnumSet.copyOf(resourceTypes);
    }

    public void withSubjectDN(X500Principal subject) {
        this.subject = subject;
    }

    public void withIssuerDN(X500Principal issuer) {
        this.issuer = issuer;
    }

    public void withValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public void withCrlUri(URI crlUri) {
        Validate.notNull((Object)crlUri, (String)"CRL Uri can not be null");
        this.validateIsRsyncUri(crlUri);
        this.crlUri = crlUri;
    }

    protected void validateIsRsyncUri(URI crlUri) {
        Validate.isTrue((boolean)crlUri.toString().startsWith("rsync:"), (String)"Rsync URI is required, multiple repositories not supported by this builder at this time");
    }

    protected boolean isSelfSigned() {
        return this.signingKeyPair.getPublic().equals(this.publicKey);
    }

    public void withParentResourceCertificatePublicationUri(URI parentResourceCertificatePublicationUri) {
        this.parentResourceCertificatePublicationUri = parentResourceCertificatePublicationUri;
    }

    public void withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
    }

    protected X509ResourceCertificateBuilder createGenericRpkiCertificateBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withPublicKey(this.publicKey);
        builder.withSigningKeyPair(this.signingKeyPair);
        builder.withSerial(this.serial);
        builder.withResources(this.resources);
        builder.withInheritedResourceTypes(this.inheritedResourceTypes);
        builder.withSubjectDN(this.subject);
        builder.withIssuerDN(this.issuer);
        builder.withValidityPeriod(this.validityPeriod);
        if (!this.isSelfSigned()) {
            builder.withCrlDistributionPoints(this.crlUri);
            X509CertificateInformationAccessDescriptor[] aiaDescriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, this.parentResourceCertificatePublicationUri)};
            builder.withAuthorityInformationAccess(aiaDescriptors);
            builder.withAuthorityKeyIdentifier(true);
        }
        builder.withSignatureProvider(this.signatureProvider);
        builder.withSubjectKeyIdentifier(true);
        return builder;
    }

    protected void validateFields() {
        Validate.notNull((Object)this.publicKey, (String)"Public Key is required");
        Validate.notNull((Object)this.signingKeyPair, (String)"Signing Key Pair is required");
        Validate.notNull((Object)this.serial, (String)"Serial is required");
        Validate.isTrue((!this.inheritedResourceTypes.isEmpty() || !this.resources.isEmpty() ? 1 : 0) != 0, (String)"Resources are required. Inherited resources are allowed but not advised (unless you are building an EE cert for manifests)");
        Validate.notNull((Object)this.subject, (String)"Subject is required");
        Validate.notNull((Object)this.issuer, (String)"Issuer is required");
        Validate.notNull((Object)this.validityPeriod, (String)"ValidityPeriod is required");
        if (!this.isSelfSigned()) {
            Validate.notNull((Object)this.crlUri, (String)"CRL URI is required (except for self-signed (root) certificates)");
            Validate.notNull((Object)this.parentResourceCertificatePublicationUri, (String)"Parent Certificate Publication URI is required");
        }
        Validate.notNull((Object)this.signatureProvider, (String)"SignatureProvider is required");
    }
}

