/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import net.ripe.rpki.commons.util.VersionedId;
import net.ripe.rpki.commons.xml.converters.VersionedIdConverter;
import org.junit.Assert;
import org.junit.Test;

public class VersionedIdConverterTest {
    private VersionedIdConverter subject = new VersionedIdConverter();

    @Test
    public void shouldSupportVersionedId() {
        Assert.assertTrue((boolean)this.subject.canConvert(VersionedId.class));
    }

    @Test
    public void shouldParseVersionId() {
        Assert.assertEquals((Object)new VersionedId(13L, 0L), (Object)this.subject.fromString("13"));
        Assert.assertEquals((Object)new VersionedId(99L, 0L), (Object)this.subject.fromString("99:0"));
        Assert.assertEquals((Object)new VersionedId(99L, 13L), (Object)this.subject.fromString("99:13"));
        Assert.assertEquals((Object)new VersionedId(42L), (Object)this.subject.fromString("42:-1"));
    }

    @Test
    public void shouldFormatVersionedId() {
        Assert.assertEquals((Object)"13:0", (Object)this.subject.toString((Object)new VersionedId(13L, 0L)));
        Assert.assertEquals((Object)"42:-1", (Object)this.subject.toString((Object)new VersionedId(42L)));
        Assert.assertEquals((Object)"99:13", (Object)this.subject.toString((Object)new VersionedId(99L, 13L)));
    }
}

