/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public final class PregeneratedKeyPairFactory
extends KeyPairFactory {
    private static final PregeneratedKeyPairFactory INSTANCE = new PregeneratedKeyPairFactory("SunRsaSign");
    private static final char[] PASSPHRASE = "passphrase".toCharArray();
    private File keyStoreFile = new File(".pregenerated-test-key-pairs.keystore");
    private KeyStore pregeneratedKeys;
    private int count = 0;

    private PregeneratedKeyPairFactory(String provider) {
        super(provider);
        this.initKeyStore();
    }

    private void initKeyStore() {
        FileInputStream input;
        try {
            input = new FileInputStream(this.keyStoreFile);
        }
        catch (FileNotFoundException e) {
            input = null;
        }
        try {
            this.pregeneratedKeys = KeyStore.getInstance("JKS", "SUN");
            this.pregeneratedKeys.load(input, PASSPHRASE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static PregeneratedKeyPairFactory getInstance() {
        return INSTANCE;
    }

    public KeyPairFactory withProvider(String provider) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized KeyPair generate() {
        try {
            KeyPair result;
            String alias = "key_" + this.count;
            ++this.count;
            PrivateKey key = (PrivateKey)this.pregeneratedKeys.getKey(alias, PASSPHRASE);
            if (key == null) {
                result = super.generate();
                this.pregeneratedKeys.setKeyEntry(alias, result.getPrivate(), PASSPHRASE, new Certificate[]{PregeneratedKeyPairFactory.createCertificate(result).getCertificate()});
                FileOutputStream output = new FileOutputStream(this.keyStoreFile);
                try {
                    this.pregeneratedKeys.store(output, PASSPHRASE);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
            } else {
                Certificate certificate = this.pregeneratedKeys.getCertificateChain(alias)[0];
                result = new KeyPair(certificate.getPublicKey(), key);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static X509ResourceCertificate createCertificate(KeyPair keyPair) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSignatureProvider("SunRsaSign");
        builder.withSerial(BigInteger.ONE);
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)new DateTime().minusYears(2), (ReadableInstant)new DateTime().minusYears(1)));
        builder.withCa(false);
        builder.withIssuerDN(new X500Principal("CN=issuer"));
        builder.withSubjectDN(new X500Principal("CN=subject"));
        builder.withResources(IpResourceSet.parse((String)"AS1-AS10,10/8,ffc0::/16"));
        builder.withSigningKeyPair(keyPair);
        builder.withPublicKey(keyPair.getPublic());
        return builder.build();
    }
}

