/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import net.ripe.rpki.commons.crypto.util.KeyStoreException;
import net.ripe.rpki.commons.crypto.util.KeyStoreUtil;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreUtilTest {
    private static KeyPair TEST_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private KeyStore keyStore;
    private byte[] keyStoreData;
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_KEYSTORE_PROVIDER = "SUN";

    @Test
    public void shouldKeyStoreContainExpiredCertificate() throws Exception {
        this.keyStore = KeyStoreUtil.createKeyStoreForKeyPair((KeyPair)TEST_KEY_PAIR, (String)DEFAULT_KEYSTORE_PROVIDER, (String)"SunRsaSign", (String)DEFAULT_KEYSTORE_TYPE);
        this.keyStoreData = KeyStoreUtil.storeKeyStore((KeyStore)this.keyStore);
        Certificate c = this.keyStore.getCertificateChain("mykey1")[0];
        String location = "unknown.cer";
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        parser.parse(location, c.getEncoded());
        X509ResourceCertificate certificate = parser.getCertificate();
        Assert.assertTrue((boolean)certificate.getValidityPeriod().isExpiredNow());
    }

    @Test
    public void shouldGetKeyPairFromKeyStore() {
        this.keyStore = KeyStoreUtil.createKeyStoreForKeyPair((KeyPair)TEST_KEY_PAIR, (String)DEFAULT_KEYSTORE_PROVIDER, (String)"SunRsaSign", (String)DEFAULT_KEYSTORE_TYPE);
        this.keyStoreData = KeyStoreUtil.storeKeyStore((KeyStore)this.keyStore);
        KeyPair keyPair = KeyStoreUtil.getKeyPairFromKeyStore((byte[])this.keyStoreData, (String)DEFAULT_KEYSTORE_PROVIDER, (String)DEFAULT_KEYSTORE_TYPE);
        Assert.assertEquals((Object)TEST_KEY_PAIR.getPrivate(), (Object)keyPair.getPrivate());
        Assert.assertEquals((Object)TEST_KEY_PAIR.getPublic(), (Object)keyPair.getPublic());
    }

    @Test
    public void shouldClearKeyStore() throws GeneralSecurityException {
        this.keyStore = KeyStoreUtil.createKeyStoreForKeyPair((KeyPair)TEST_KEY_PAIR, (String)DEFAULT_KEYSTORE_PROVIDER, (String)"SunRsaSign", (String)DEFAULT_KEYSTORE_TYPE);
        this.keyStoreData = KeyStoreUtil.storeKeyStore((KeyStore)this.keyStore);
        KeyStore emptyKeyStore = KeyStoreUtil.clearKeyStore((byte[])this.keyStoreData, (String)DEFAULT_KEYSTORE_PROVIDER, (String)DEFAULT_KEYSTORE_TYPE);
        Assert.assertFalse((boolean)emptyKeyStore.containsAlias("mykey1"));
    }

    @Test(expected=KeyStoreException.class)
    public void shouldCreateKeyStoreHandleError() throws GeneralSecurityException {
        KeyStoreUtil.createKeyStoreForKeyPair((KeyPair)TEST_KEY_PAIR, (String)"foo keystore provider", (String)"SunRsaSign", (String)DEFAULT_KEYSTORE_TYPE);
    }

    @Test(expected=KeyStoreException.class)
    public void shouldClearKeyStoreHandleError() throws GeneralSecurityException {
        KeyStoreUtil.clearKeyStore((byte[])new byte[0], (String)DEFAULT_KEYSTORE_PROVIDER, (String)DEFAULT_KEYSTORE_TYPE);
    }

    @Test(expected=KeyStoreException.class)
    public void shouldStoreKeyStoreHandleError() throws GeneralSecurityException {
        KeyStoreUtil.storeKeyStore((KeyStore)KeyStore.getInstance(DEFAULT_KEYSTORE_TYPE, DEFAULT_KEYSTORE_PROVIDER));
    }
}

