/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import net.ripe.rpki.commons.FixedDateRule;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectPrinter;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CertificateRepositoryObjectPrinterTest {
    @Rule
    public FixedDateRule fixedDateRule = new FixedDateRule(new DateTime(2008, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC));

    @Test
    public void shouldPrintManifestCms() {
        ManifestCms manifest = ManifestCmsTest.getRootManifestCms();
        StringWriter output = new StringWriter();
        CertificateRepositoryObjectPrinter.print((PrintWriter)new PrintWriter(output), (CertificateRepositoryObject)manifest);
        Assert.assertEquals((Object)"Object Type: RPKI Manifest\nSigning time: 2008-09-01T22:43:29.000Z\nVersion: 0\nNumber: 68\nThis update time: 2008-09-01T22:43:29.000Z\nNext update time: 2008-09-02T06:43:29.000Z\nFilenames and hashes:\n    filename1 ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad\n    filename2 cb8379ac2098aa165029e3938a51da0bcecfc008fd6795f401178647f96c5b34\n", (Object)output.getBuffer().toString());
    }

    @Test
    public void shouldPrintResourceCertificate() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)new DateTime(2008, 1, 4, 0, 0, 0, 0, DateTimeZone.UTC), (ReadableInstant)new DateTime(2009, 1, 4, 0, 0, 0, 0, DateTimeZone.UTC)));
        X509ResourceCertificate certificate = builder.build();
        StringWriter output = new StringWriter();
        CertificateRepositoryObjectPrinter.print((PrintWriter)new PrintWriter(output), (CertificateRepositoryObject)certificate);
        Assert.assertEquals((Object)"Object Type: X509Certificate with RFC3779 Internet Resource Extension\nSerial: 900\nSubject: CN=TEST-SELF-SIGNED-CERT\nNot valid before: 2008-01-04T00:00:00.000Z\nNot valid after:  2009-01-04T00:00:00.000Z\nResources: AS21212, 10.0.0.0/8, 192.168.0.0/16, ffce::/16\n", (Object)output.getBuffer().toString());
    }

    @Test
    public void shouldPrintRoa() {
        StringWriter output = new StringWriter();
        RoaCms roaCms = RoaCmsTest.getRoaCms();
        CertificateRepositoryObjectPrinter.print((PrintWriter)new PrintWriter(output), (CertificateRepositoryObject)roaCms);
        Assert.assertEquals((Object)"Object Type: Route Origin Authorisation object\nSigning time: 2007-12-31T23:59:00.000Z\nASN: AS42\nPrefixes:\n    10.64.0.0/12 [24]\n    10.32.0.0/12\n    2001:0:200::/39\n", (Object)output.getBuffer().toString());
    }

    @Test
    public void shouldPrintCRL() {
        X509CrlBuilder builder = X509CrlTest.getCrlBuilder();
        builder.addEntry(BigInteger.TEN, new DateTime().minusDays(1));
        builder.addEntry(BigInteger.valueOf(42L), new DateTime().minusDays(3));
        X509Crl crl = builder.build(KeyPairFactoryTest.TEST_KEY_PAIR.getPrivate());
        StringWriter output = new StringWriter();
        CertificateRepositoryObjectPrinter.print((PrintWriter)new PrintWriter(output), (CertificateRepositoryObject)crl);
        Assert.assertEquals((Object)("Object Type: Certificate Revocation List\nCRL version: 2\nIssuer: CN=issuer\nAuthority key identifier: " + KeyPairUtil.base64UrlEncode((byte[])crl.getAuthorityKeyIdentifier()) + "\n" + "Number: 10\n" + "This update time: 2008-01-01T00:00:00.000Z\n" + "Next update time: 2008-01-01T08:00:00.000Z\n" + "Revoked certificates serial numbers and revocation time:\n" + "    10 2007-12-31T00:00:00.000Z\n" + "    42 2007-12-29T00:00:00.000Z\n"), (Object)output.getBuffer().toString());
    }
}

