/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildValidator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ManifestCmsEeCertificateValidator
extends X509ResourceCertificateParentChildValidator {
    public ManifestCmsEeCertificateValidator(ValidationOptions options, ValidationResult result, X509ResourceCertificate parent, X509Crl crl, IpResourceSet resources) {
        super(options, result, parent, crl, resources);
    }

    @Override
    protected void verifyValidity() {
        DateTime now = new DateTime();
        this.result.rejectIfTrue(now.isBefore((ReadableInstant)((X509ResourceCertificate)this.child).getValidityPeriod().getNotValidBefore()), "cert.not.valid.before", ((X509ResourceCertificate)this.child).getValidityPeriod().getNotValidBefore().toString());
        DateTime notValidAfter = ((X509ResourceCertificate)this.child).getValidityPeriod().getNotValidAfter();
        if (now.isAfter((ReadableInstant)notValidAfter)) {
            if (notValidAfter.plus((long)this.options.getMaxStaleDays()).isAfter((ReadableInstant)now)) {
                this.result.warnIfTrue(true, "cert.not.valid.after", notValidAfter.toString());
            } else {
                this.result.rejectIfTrue(true, "cert.not.valid.after", notValidAfter.toString());
            }
        }
    }
}

