/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509;

import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateBuilderTest;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateParser;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningCmsCertificateParserTest {
    private ProvisioningCmsCertificateParser subject;

    @Before
    public void setUp() {
        this.subject = new ProvisioningCmsCertificateParser();
    }

    @Test
    public void shouldParseValidObject() {
        this.subject.parse("placeholder location", ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getEncoded());
        Assert.assertEquals((Object)ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT, (Object)this.subject.getCertificate());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnInvalidObject() {
        this.subject.parse("placeholder location", new byte[]{0});
        ValidationResult validationResult = this.subject.getValidationResult();
        Assert.assertTrue((boolean)validationResult.hasFailures());
        Assert.assertEquals((long)1L, (long)validationResult.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)"cert.parsed", (Object)((ValidationCheck)validationResult.getFailuresForCurrentLocation().iterator().next()).getKey());
        this.subject.getCertificate();
    }
}

