/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.VersionedId;
import net.ripe.rpki.commons.validation.roa.AnnouncedRoute;
import net.ripe.rpki.commons.validation.roa.RouteValidityState;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import net.ripe.rpki.commons.xml.converters.DateTimeConverter;
import net.ripe.rpki.commons.xml.converters.IpResourceConverter;
import net.ripe.rpki.commons.xml.converters.IpResourceSetConverter;
import net.ripe.rpki.commons.xml.converters.JavaUtilTimestampConverter;
import net.ripe.rpki.commons.xml.converters.ManifestCmsConverter;
import net.ripe.rpki.commons.xml.converters.ReadablePeriodConverter;
import net.ripe.rpki.commons.xml.converters.RoaCmsConverter;
import net.ripe.rpki.commons.xml.converters.VersionedIdConverter;
import net.ripe.rpki.commons.xml.converters.X500PrincipalConverter;
import net.ripe.rpki.commons.xml.converters.X509ResourceCertificateConverter;
import org.joda.time.DateTime;

public class XStreamXmlSerializerBuilder<T> {
    private XStream xStream;
    private Class<T> objectType;

    public XStreamXmlSerializerBuilder(Class<T> objectType) {
        this.objectType = objectType;
        this.createDefaultXStream();
    }

    private void createDefaultXStream() {
        this.xStream = new MyXStream(this.getStreamDriver());
        this.xStream.setMode(1001);
        this.registerIpResourceRelated();
        this.registerDateTimeRelated();
        this.registerRpkiRelated();
    }

    protected HierarchicalStreamDriver getStreamDriver() {
        return new XppDriver();
    }

    protected final Class<T> getObjectType() {
        return this.objectType;
    }

    private void registerIpResourceRelated() {
        this.withAliasType("resource", IpResource.class);
        this.withConverter((SingleValueConverter)new IpResourceConverter());
        this.withAliasType("resource-set", IpResourceSet.class);
        this.withConverter((SingleValueConverter)new IpResourceSetConverter());
    }

    private void registerDateTimeRelated() {
        this.withAliasType("datetime", DateTime.class);
        this.withConverter(new DateTimeConverter());
        this.withConverter(new ReadablePeriodConverter());
        this.withConverter(new JavaUtilTimestampConverter());
        this.withAliasType("ValidityPeriod", ValidityPeriod.class);
    }

    private void registerRpkiRelated() {
        this.withAliasType("X509ResourceCertificate", X509ResourceCertificate.class);
        this.withAliasType("X509Crl", X509Crl.class);
        this.withAliasType("ManifestCms", ManifestCms.class);
        this.withAliasType("RoaCms", RoaCms.class);
        this.withAliasType("RouteValidityState", RouteValidityState.class);
        this.withAliasType("RoaPrefix", RoaPrefix.class);
        this.withAliasType("AnnouncedRoute", AnnouncedRoute.class);
        this.withAliasType("X509CertificateInformationAccessDescriptor", X509CertificateInformationAccessDescriptor.class);
        this.withAliasType("principal", X500Principal.class);
        this.withConverter(new X500PrincipalConverter());
        this.withAliasType("versionedId", VersionedId.class);
        this.withConverter(new VersionedIdConverter());
        this.withConverter(new X509ResourceCertificateConverter());
        this.withConverter(new ManifestCmsConverter());
        this.withConverter(new RoaCmsConverter());
    }

    public final XStreamXmlSerializerBuilder<T> withConverter(Converter converter) {
        this.xStream.registerConverter(converter);
        return this;
    }

    public final XStreamXmlSerializerBuilder<T> withConverter(SingleValueConverter converter) {
        this.xStream.registerConverter(converter);
        return this;
    }

    public final XStreamXmlSerializerBuilder<T> withAliasType(String alias, Class<?> type) {
        this.xStream.aliasType(alias, type);
        return this;
    }

    public final XStreamXmlSerializerBuilder<T> withAliasPackage(String alias, String packageName) {
        this.xStream.aliasPackage(alias, packageName);
        return this;
    }

    public final XStreamXmlSerializerBuilder<T> withAttribute(String childNode, Class<?> attributeOnType) {
        this.xStream.useAttributeFor(attributeOnType, childNode);
        return this;
    }

    public final XStreamXmlSerializerBuilder<T> withAliasField(String alias, Class<?> aliasOnField, String field) {
        this.xStream.useAttributeFor(alias, aliasOnField);
        this.xStream.aliasField(alias, aliasOnField, field);
        return this;
    }

    public XStreamXmlSerializer<T> build() {
        return new XStreamXmlSerializer<T>(this.xStream, this.objectType);
    }

    protected XStream getXStream() {
        return this.xStream;
    }

    private final class MyXStream
    extends XStream {
        private MyXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
            super((ReflectionProvider)new Sun14ReflectionProvider(), hierarchicalStreamDriver);
        }

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            return new MapperWrapper((Mapper)next){

                public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                    return definedIn != Object.class && super.shouldSerializeMember(definedIn, fieldName);
                }
            };
        }
    }
}

