/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.util.LinkedList;
import java.util.List;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.etree.IntervalStrategy;
import net.ripe.ipresource.etree.IpResourceIntervalStrategy;
import net.ripe.ipresource.etree.NestedIntervalMap;
import net.ripe.rpki.commons.validation.roa.AllowedRoute;
import net.ripe.rpki.commons.validation.roa.AnnouncedRoute;
import net.ripe.rpki.commons.validation.roa.RouteValidityState;

public class RouteOriginValidationPolicy {
    public static NestedIntervalMap<IpResource, List<AllowedRoute>> allowedRoutesToNestedIntervalMap(Iterable<? extends AllowedRoute> allowedRoutes) {
        NestedIntervalMap result = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());
        for (AllowedRoute allowedRoute : allowedRoutes) {
            List allowed = (List)result.findExact((Object)allowedRoute.getPrefix());
            if (allowed == null) {
                LinkedList<AllowedRoute> list = new LinkedList<AllowedRoute>();
                list.add(allowedRoute);
                result.put((Object)allowedRoute.getPrefix(), list);
                continue;
            }
            allowed.add(allowedRoute);
        }
        return result;
    }

    public RouteValidityState validateAnnouncedRoute(NestedIntervalMap<IpResource, ? extends Iterable<? extends AllowedRoute>> allowedRoutes, AnnouncedRoute announcedRoute) {
        RouteValidityState result = RouteValidityState.UNKNOWN;
        for (Iterable routes : allowedRoutes.findExactAndAllLessSpecific((Object)announcedRoute.getPrefix())) {
            for (AllowedRoute allowedRoute : routes) {
                switch (this.validate(allowedRoute, announcedRoute)) {
                    case VALID: {
                        return RouteValidityState.VALID;
                    }
                    case INVALID: {
                        result = RouteValidityState.INVALID;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private RouteValidityState validate(AllowedRoute allowedRoute, AnnouncedRoute announcedRoute) {
        IpRange announcedPrefix = announcedRoute.getPrefix();
        if (!allowedRoute.getPrefix().contains((IpResource)announcedPrefix)) {
            return RouteValidityState.UNKNOWN;
        }
        if (announcedPrefix.getPrefixLength() <= allowedRoute.getMaximumLength()) {
            if (allowedRoute.getAsn().equals((Object)announcedRoute.getOriginAsn())) {
                return RouteValidityState.VALID;
            }
            return RouteValidityState.INVALID;
        }
        return RouteValidityState.INVALID;
    }
}

