/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.io.Serializable;
import java.util.Comparator;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import org.apache.commons.lang.Validate;

public final class AnnouncedRoute
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Comparator<AnnouncedRoute> ASN_PREFIX_COMPARATOR = new Comparator<AnnouncedRoute>(){

        @Override
        public int compare(AnnouncedRoute o1, AnnouncedRoute o2) {
            int rc = o1.getOriginAsn().compareTo((IpResource)o2.getOriginAsn());
            if (rc != 0) {
                return rc;
            }
            return o1.getPrefix().compareTo((IpResource)o2.getPrefix());
        }
    };
    private final Asn originAsn;
    private final IpRange prefix;

    public AnnouncedRoute(Asn originAsn, IpRange prefix) {
        Validate.notNull((Object)originAsn, (String)"origin is required");
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)"Prefix must be legal");
        this.originAsn = originAsn;
        this.prefix = prefix;
    }

    public Asn getOriginAsn() {
        return this.originAsn;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.originAsn.hashCode();
        result = 31 * result + this.prefix.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnouncedRoute that = (AnnouncedRoute)obj;
        return this.originAsn.equals((Object)that.originAsn) && this.prefix.equals((Object)that.prefix);
    }

    public String toString() {
        return "AnnouncedRoute [originAsn=" + this.originAsn + ", prefix=" + this.prefix + "]";
    }
}

