/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import java.net.URI;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CertificateRepositoryObjectValidationContext {
    private final URI location;
    private final X509ResourceCertificate certificate;
    private final IpResourceSet resources;

    public CertificateRepositoryObjectValidationContext(URI location, X509ResourceCertificate certificate) {
        this(location, certificate, certificate.getResources());
    }

    public CertificateRepositoryObjectValidationContext(URI location, X509ResourceCertificate certificate, IpResourceSet resources) {
        this.location = location;
        this.certificate = certificate;
        this.resources = resources;
    }

    public URI getLocation() {
        return this.location;
    }

    public X509ResourceCertificate getCertificate() {
        return this.certificate;
    }

    public IpResourceSet getResources() {
        return this.resources;
    }

    public URI getManifestURI() {
        return this.certificate.getManifestUri();
    }

    public URI getRepositoryURI() {
        return this.certificate.getRepositoryUri();
    }

    public CertificateRepositoryObjectValidationContext createChildContext(URI childLocation, X509ResourceCertificate childCertificate) {
        return new CertificateRepositoryObjectValidationContext(childLocation, childCertificate, childCertificate.deriveResources(this.resources));
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.location).append((Object)this.certificate).append((Object)this.resources).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateRepositoryObjectValidationContext that = (CertificateRepositoryObjectValidationContext)obj;
        return new EqualsBuilder().append((Object)this.getLocation(), (Object)that.getLocation()).append((Object)this.getCertificate(), (Object)that.getCertificate()).append((Object)this.getResources(), (Object)that.getResources()).isEquals();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

