/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.issue.request;

import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.provisioning.payload.common.AbstractPayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestElement;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayload;
import org.apache.commons.lang.Validate;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertificateIssuanceRequestPayloadBuilder
extends AbstractPayloadBuilder<CertificateIssuanceRequestPayload> {
    private String className;
    private IpResourceSet asn;
    private IpResourceSet ipv4ResourceSet;
    private IpResourceSet ipv6ResourceSet;
    private PKCS10CertificationRequest certificateRequest;

    public CertificateIssuanceRequestPayloadBuilder withClassName(String className) {
        this.className = className;
        return this;
    }

    public CertificateIssuanceRequestPayloadBuilder withAllocatedAsn(IpResourceSet asnResourceSet) {
        this.asn = asnResourceSet;
        return this;
    }

    public CertificateIssuanceRequestPayloadBuilder withIpv4ResourceSet(IpResourceSet ipv4ResourceSet) {
        this.ipv4ResourceSet = ipv4ResourceSet;
        return this;
    }

    public CertificateIssuanceRequestPayloadBuilder withIpv6ResourceSet(IpResourceSet ipv6ResourceSet) {
        this.ipv6ResourceSet = ipv6ResourceSet;
        return this;
    }

    public CertificateIssuanceRequestPayloadBuilder withCertificateRequest(PKCS10CertificationRequest certificateRequest) {
        this.certificateRequest = certificateRequest;
        return this;
    }

    @Override
    public CertificateIssuanceRequestPayload build() {
        Validate.notNull((Object)this.className, (String)"No className provided");
        Validate.notNull((Object)this.certificateRequest);
        CertificateIssuanceRequestElement content = new CertificateIssuanceRequestElement().setClassName(this.className).setAllocatedAsn(this.asn).setAllocatedIpv4(this.ipv4ResourceSet).setAllocatedIpv6(this.ipv6ResourceSet).setCertificateRequest(this.certificateRequest);
        return new CertificateIssuanceRequestPayload(content);
    }
}

