/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.issue.request;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElementConverter;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestElement;
import org.apache.commons.lang.Validate;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertificateIssuanceRequestElementConverter
implements Converter {
    private static final String CLASS_NAME = "class_name";
    private static final String REQ_RESOURCE_SET_AS = "req_resource_set_as";
    private static final String REQ_RESOURCE_SET_IPV4 = "req_resource_set_ipv4";
    private static final String REQ_RESOURCE_SET_IPV6 = "req_resource_set_ipv6";

    public boolean canConvert(Class type) {
        return type == CertificateIssuanceRequestElement.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        try {
            CertificateIssuanceRequestElement content = (CertificateIssuanceRequestElement)source;
            writer.addAttribute(CLASS_NAME, content.getClassName());
            CertificateElementConverter.encodeResources(writer, REQ_RESOURCE_SET_AS, content.getAllocatedAsn());
            CertificateElementConverter.encodeResources(writer, REQ_RESOURCE_SET_IPV4, content.getAllocatedIpv4());
            CertificateElementConverter.encodeResources(writer, REQ_RESOURCE_SET_IPV6, content.getAllocatedIpv6());
            context.convertAnother((Object)content.getCertificateRequest().getEncoded());
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            CertificateIssuanceRequestElement content = new CertificateIssuanceRequestElement();
            String className = reader.getAttribute(CLASS_NAME);
            Validate.notNull((Object)className, (String)"class_name attribute is required");
            content.setClassName(className);
            content.setAllocatedAsn(CertificateElementConverter.decodeResources(reader, REQ_RESOURCE_SET_AS));
            content.setAllocatedIpv4(CertificateElementConverter.decodeResources(reader, REQ_RESOURCE_SET_IPV4));
            content.setAllocatedIpv6(CertificateElementConverter.decodeResources(reader, REQ_RESOURCE_SET_IPV6));
            content.setCertificateRequest(this.decodeCertificateRequest(reader, context));
            return content;
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    private PKCS10CertificationRequest decodeCertificateRequest(HierarchicalStreamReader reader, UnmarshallingContext context) throws IOException {
        String encodedCertificate = reader.getValue();
        Validate.notNull((Object)encodedCertificate, (String)"No certificate found");
        byte[] base64DecodedCertificate = (byte[])context.convertAnother((Object)encodedCertificate.getBytes(), byte[].class);
        return new PKCS10CertificationRequest(base64DecodedCertificate);
    }
}

