/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.common;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.net.URI;
import java.util.List;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.serialization.CertificateUrlListConverter;
import net.ripe.rpki.commons.provisioning.serialization.IpResourceSetProvisioningConverter;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class CertificateElementConverter
implements Converter {
    private static final String CERT_URL = "cert_url";
    private static final String REQ_RESOURCE_SET_AS = "req_resource_set_as";
    private static final String REQ_RESOURCE_SET_IPV4 = "req_resource_set_ipv4";
    private static final String REQ_RESOURCE_SET_IPV6 = "req_resource_set_ipv6";

    public boolean canConvert(Class type) {
        return type == CertificateElement.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        CertificateElement certificateElement = (CertificateElement)source;
        writer.addAttribute(CERT_URL, CertificateUrlListConverter.INSTANCE.toString(certificateElement.getIssuerCertificatePublicationUris()));
        CertificateElementConverter.encodeResources(writer, REQ_RESOURCE_SET_AS, certificateElement.getAllocatedAsn());
        CertificateElementConverter.encodeResources(writer, REQ_RESOURCE_SET_IPV4, certificateElement.getAllocatedIpv4());
        CertificateElementConverter.encodeResources(writer, REQ_RESOURCE_SET_IPV6, certificateElement.getAllocatedIpv6());
        context.convertAnother((Object)certificateElement.getCertificate().getEncoded());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        CertificateElement certificateElement = new CertificateElement();
        String uriString = reader.getAttribute(CERT_URL);
        Validate.notNull((Object)uriString, (String)"cert_url attribute is required");
        certificateElement.setIssuerCertificatePublicationLocation((List<URI>)CertificateUrlListConverter.INSTANCE.fromString(uriString));
        certificateElement.setAllocatedAsn(CertificateElementConverter.decodeResources(reader, REQ_RESOURCE_SET_AS));
        certificateElement.setAllocatedIpv4(CertificateElementConverter.decodeResources(reader, REQ_RESOURCE_SET_IPV4));
        certificateElement.setAllocatedIpv6(CertificateElementConverter.decodeResources(reader, REQ_RESOURCE_SET_IPV6));
        certificateElement.setCertificate(this.decodeCertificate(reader, context));
        return certificateElement;
    }

    private X509ResourceCertificate decodeCertificate(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String encodedCertificate = reader.getValue();
        Validate.notNull((Object)encodedCertificate, (String)"No certificate found");
        byte[] base64DecodedCertificate = (byte[])context.convertAnother((Object)encodedCertificate.getBytes(), byte[].class);
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        parser.parse(ValidationResult.withLocation("unknown.cer"), base64DecodedCertificate);
        return parser.getCertificate();
    }

    public static IpResourceSet decodeResources(HierarchicalStreamReader reader, String attribute) {
        String resources = reader.getAttribute(attribute);
        if (StringUtils.isBlank((String)resources)) {
            return null;
        }
        return IpResourceSetProvisioningConverter.INSTANCE.fromString(resources);
    }

    public static void encodeResources(HierarchicalStreamWriter writer, String attribute, IpResourceSet resources) {
        if (resources != null && !resources.isEmpty()) {
            writer.addAttribute(attribute, IpResourceSetProvisioningConverter.INSTANCE.toString(resources));
        }
    }
}

