/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilderException;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import org.apache.commons.io.IOUtils;

class ProvisioningPayloadXmlSerializer<T extends AbstractProvisioningPayload>
extends XStreamXmlSerializer<T> {
    public ProvisioningPayloadXmlSerializer(XStream xStream, Class<T> objectType) {
        super(xStream, objectType);
    }

    @Override
    public String serialize(T object) {
        try {
            return this.serializeUTF8Encoded(object);
        }
        catch (IOException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializeUTF8Encoded(T payload) throws IOException {
        String string;
        ByteArrayOutputStream outputStream = null;
        OutputStreamWriter writer = null;
        try {
            outputStream = new ByteArrayOutputStream();
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.getProperty("line.separator"));
            super.serialize(payload, writer);
            String xml = outputStream.toString("UTF-8");
            string = xml.replace("<message", "<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return string;
    }
}

