/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsGeneralInfo;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ManifestCmsParser
extends RpkiSignedObjectParser {
    private int version = 0;
    private static final int MANIFEST_CONTENT_SEQUENCE_LENGTH = 5;
    private static final int MANIFEST_NUMBER_INDEX = 0;
    private static final int THIS_UPDATE_TIME_INDEX = 1;
    private static final int NEXT_UPDATE_TIME_INDEX = 2;
    private static final int FILE_HASH_ALGORHYTHM_INDEX = 3;
    private static final int FILE_LIST_INDEX = 4;
    private BigInteger number;
    private DateTime thisUpdateTime;
    private DateTime nextUpdateTime;
    private String fileHashAlgorithm;
    private Map<String, byte[]> files;

    @Override
    public void parse(ValidationResult result, byte[] encoded) {
        super.parse(result, encoded);
        if (this.isSuccess()) {
            this.validateManifest();
        }
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailures();
    }

    public ManifestCms getManifestCms() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Manifest validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectData = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        ManifestCmsGeneralInfo manifestCmsGeneralInfo = new ManifestCmsGeneralInfo(this.version, this.number, this.thisUpdateTime, this.nextUpdateTime, this.fileHashAlgorithm);
        return new ManifestCms(cmsObjectData, manifestCmsGeneralInfo, this.files);
    }

    private void validateManifest() {
        ValidationResult validationResult = this.getValidationResult();
        validationResult.rejectIfFalse(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.26").equals((Object)this.getContentType()), "mf.content.type", new String[0]);
        validationResult.rejectIfFalse(this.getResourceCertificate().isResourceSetInherited(), "mf.resource.inherit", new String[0]);
    }

    void decodeManifest(ASN1Encodable encoded) {
        ValidationResult validationResult = this.getValidationResult();
        try {
            ASN1Sequence seq = Asn1Util.expect(encoded, ASN1Sequence.class);
            validationResult.rejectIfFalse(seq.size() == 5, "mf.content.size", new String[0]);
            if (validationResult.hasFailureForCurrentLocation()) {
                return;
            }
            this.version = 0;
            this.number = Asn1Util.expect(seq.getObjectAt(0), ASN1Integer.class).getValue();
            this.thisUpdateTime = new DateTime(Asn1Util.expect(seq.getObjectAt(1), ASN1GeneralizedTime.class).getDate().getTime(), DateTimeZone.UTC);
            this.nextUpdateTime = new DateTime(Asn1Util.expect(seq.getObjectAt(2), ASN1GeneralizedTime.class).getDate().getTime(), DateTimeZone.UTC);
            this.fileHashAlgorithm = Asn1Util.expect(seq.getObjectAt(3), ASN1ObjectIdentifier.class).getId();
            validationResult.rejectIfFalse(ManifestCms.FILE_HASH_ALGORITHM.equals(this.fileHashAlgorithm), "mf.file.hash.algorithm", this.fileHashAlgorithm);
            this.files = new TreeMap<String, byte[]>();
            this.decodeFileList(this.files, seq.getObjectAt(4));
        }
        catch (IllegalArgumentException e) {
            validationResult.error("mf.content.structure", new String[0]);
        }
        catch (ParseException e) {
            validationResult.error("mf.time.format", new String[0]);
        }
    }

    void decodeFileAndHash(Map<String, byte[]> result, ASN1Encodable encoded) {
        ASN1Sequence seq = Asn1Util.expect(encoded, ASN1Sequence.class);
        Validate.isTrue((seq.size() == 2 ? 1 : 0) != 0, (String)"der sequence does not contain file and hash");
        DERIA5String derFile = Asn1Util.expect(seq.getObjectAt(0), DERIA5String.class);
        DERBitString derHash = Asn1Util.expect(seq.getObjectAt(1), DERBitString.class);
        result.put(derFile.getString(), derHash.getBytes());
    }

    void decodeFileList(Map<String, byte[]> result, ASN1Encodable encoded) {
        ASN1Sequence seq = Asn1Util.expect(encoded, ASN1Sequence.class);
        boolean errorOccured = false;
        for (int i = 0; i < seq.size(); ++i) {
            try {
                this.decodeFileAndHash(result, seq.getObjectAt(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                errorOccured = true;
                break;
            }
        }
        this.getValidationResult().rejectIfTrue(errorOccured, "mf.decode.filelist", new String[0]);
    }

    @Override
    public void decodeContent(ASN1Encodable encoded) {
        this.decodeManifest(encoded);
    }
}

