/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import net.ripe.rpki.commons.util.VersionedId;
import org.junit.Assert;
import org.junit.Test;

public class VersionedIdTest {
    @Test
    public void shouldDefaultToInitialVersion() {
        VersionedId subject = new VersionedId(9L);
        Assert.assertEquals((long)9L, (long)subject.getId());
        Assert.assertEquals((long)-1L, (long)subject.getVersion());
    }

    @Test
    public void shouldHaveIdAndVersion() {
        VersionedId subject = new VersionedId(12L, 32L);
        Assert.assertEquals((long)12L, (long)subject.getId());
        Assert.assertEquals((long)32L, (long)subject.getVersion());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new VersionedId(12L, 32L), (Object)new VersionedId(12L, 32L));
        Assert.assertEquals((long)new VersionedId(12L, 32L).hashCode(), (long)new VersionedId(12L, 32L).hashCode());
        Assert.assertFalse((boolean)new VersionedId(12L, 32L).equals((Object)new VersionedId(13L, 32L)));
        Assert.assertFalse((boolean)new VersionedId(12L, 32L).equals((Object)new VersionedId(12L, 33L)));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"12:32", (Object)new VersionedId(12L, 32L).toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseEmptyString() {
        VersionedId.parse((String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseNullString() {
        VersionedId.parse(null);
    }

    @Test
    public void shouldParseIdWithVersion() {
        Assert.assertEquals((Object)new VersionedId(3L, 24L), (Object)VersionedId.parse((String)"3:24"));
    }

    @Test
    public void shouldParseWithoutVersion() {
        Assert.assertEquals((Object)new VersionedId(3L, 0L), (Object)VersionedId.parse((String)"3"));
    }
}

