/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.issue.request;

import java.io.IOException;
import java.util.regex.Pattern;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestElement;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayload;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayloadSerializerBuilder;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class CertificateIssuanceRequestPayloadBuilderTest {
    private static final XStreamXmlSerializer<CertificateIssuanceRequestPayload> SERIALIZER = new CertificateIssuanceRequestPayloadSerializerBuilder().build();
    public static final CertificateIssuanceRequestPayload TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD = CertificateIssuanceRequestPayloadBuilderTest.createCertificateIssuanceRequestPayloadForPkcs10Request(ProvisioningObjectMother.RPKI_CA_CERT_REQUEST);

    public static CertificateIssuanceRequestPayload createCertificateIssuanceRequestPayloadForPkcs10Request(PKCS10CertificationRequest pkcs10Request) {
        CertificateIssuanceRequestPayloadBuilder builder = new CertificateIssuanceRequestPayloadBuilder();
        builder.withClassName("ripe-region");
        builder.withAllocatedAsn(IpResourceSet.parse((String)"1234,456"));
        builder.withIpv4ResourceSet(IpResourceSet.parse((String)"10.0.0.0/8"));
        builder.withIpv6ResourceSet(IpResourceSet.parse((String)"2001:0DB8::/48,2001:0DB8:002::-2001:0DB8:005::"));
        builder.withCertificateRequest(pkcs10Request);
        return builder.build();
    }

    @Test
    public void shouldBuildValidListResponsePayload() throws IOException {
        Assert.assertEquals((Object)"sender", (Object)TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD.getRecipient());
        CertificateIssuanceRequestElement payloadContent = TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD.getRequestElement();
        Assert.assertEquals((Object)"ripe-region", (Object)payloadContent.getClassName());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"456,1234"), (Object)payloadContent.getAllocatedAsn());
        PKCS10CertificationRequest pkcs10Request = ProvisioningObjectMother.RPKI_CA_CERT_REQUEST;
        Assert.assertArrayEquals((byte[])pkcs10Request.getEncoded(), (byte[])payloadContent.getCertificateRequest().getEncoded());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"10.0.0.0/8"), (Object)payloadContent.getAllocatedIpv4());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"2001:0DB8::/48,2001:0DB8:002::-2001:0DB8:005::"), (Object)payloadContent.getAllocatedIpv6());
    }

    @Test
    public void shouldUsePayloadXmlConformDraft() {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD);
        String expectedXmlRegex = "<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>\n<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\" version=\"1\" sender=\"sender\" recipient=\"recipient\" type=\"issue\">\n  <request class_name=\"ripe-region\" req_resource_set_as=\"456,1234\" req_resource_set_ipv4=\"10.0.0.0/8\" req_resource_set_ipv6=\"2001:db8::/48,2001:db8:2::-2001:db8:5::\">[^<]*</request>\n</message>";
        Assert.assertTrue((boolean)Pattern.matches(expectedXmlRegex, actualXml));
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

