/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.interop;

import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class BbnRoaCornerCasesTest {
    private static final String PATH_TO_BBN_ROAS = "src/test/resources/bbn-standard-compliance-cases/root";

    @Test
    public void shouldRejectBadRoaVersionV2Roa() throws IOException {
        byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/bbn-standard-compliance-cases/root/badROAVersionV2.roa"));
        RoaCmsParser parser = new RoaCmsParser();
        parser.parse("roa", encoded);
        ValidationResult validationResult = parser.getValidationResult();
        for (ValidationLocation location : validationResult.getValidatedLocations()) {
            System.err.println(location + "  ->  " + validationResult.getFailures(location));
        }
        Assert.assertFalse((boolean)validationResult.hasFailures());
    }

    @Test
    public void shouldAcceptGoodRoa() throws IOException {
        byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/bbn-standard-compliance-cases/root/goodROANothingWrong.roa"));
        RoaCmsParser parser = new RoaCmsParser();
        parser.parse("roa", encoded);
        ValidationResult validationResult = parser.getValidationResult();
        for (ValidationLocation location : validationResult.getValidatedLocations()) {
            System.err.println(location + "  ->  " + validationResult.getFailures(location));
        }
        Assert.assertFalse((boolean)validationResult.hasFailures());
    }
}

