/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.util.Arrays;
import java.util.Collections;
import net.ripe.rpki.commons.FixedDateRule;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationMetric;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ValidationResultTest {
    private static final ValidationLocation SECOND_LOCATION = new ValidationLocation("secondValidatedObject");
    private static final ValidationLocation FIRST_LOCATION = new ValidationLocation("firstValidatedObject");
    private static final DateTime NOW = new DateTime(2008, 4, 5, 0, 0, 0, 0, DateTimeZone.UTC);
    @Rule
    public FixedDateRule fixedDateRule = new FixedDateRule(NOW);
    private ValidationResult result = new ValidationResult();

    @Test
    public void shouldValidateWithoutFailures() {
        this.result.setLocation(FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.rejectIfFalse(true, "A", new String[0]));
        Assert.assertTrue((boolean)this.result.rejectIfTrue(false, "B", new String[0]));
        Assert.assertTrue((boolean)this.result.rejectIfNull((Object)"", "C", new String[0]));
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertFalse((boolean)this.result.hasFailureForLocation(FIRST_LOCATION));
        Assert.assertFalse((boolean)this.result.hasFailureForLocation(new ValidationLocation("invalid object")));
        Assert.assertTrue((this.result.getValidatedLocations().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.result.getValidatedLocations().contains(FIRST_LOCATION));
        Assert.assertNotNull((Object)this.result.getAllValidationChecksForLocation(FIRST_LOCATION));
        Assert.assertEquals((long)3L, (long)this.result.getAllValidationChecksForLocation(FIRST_LOCATION).size());
        Assert.assertNotNull((Object)this.result.getFailures(FIRST_LOCATION));
        Assert.assertTrue((this.result.getFailures(FIRST_LOCATION).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldValidateWithFailures() {
        this.result.setLocation(FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.rejectIfFalse(true, "A", new String[0]));
        Assert.assertTrue((boolean)this.result.rejectIfTrue(false, "B", new String[0]));
        this.result.setLocation(SECOND_LOCATION);
        Assert.assertFalse((boolean)this.result.rejectIfFalse(false, "A", new String[0]));
        Assert.assertFalse((boolean)this.result.rejectIfTrue(true, "B", new String[0]));
        this.result.setLocation(FIRST_LOCATION);
        Assert.assertTrue((boolean)this.result.rejectIfNull((Object)"", "C", new String[0]));
        this.result.setLocation(SECOND_LOCATION);
        Assert.assertFalse((boolean)this.result.rejectIfNull(null, "C", new String[0]));
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertFalse((boolean)this.result.hasFailureForLocation(FIRST_LOCATION));
        Assert.assertTrue((boolean)this.result.hasFailureForLocation(SECOND_LOCATION));
        Assert.assertTrue((this.result.getValidatedLocations().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.result.getValidatedLocations().contains(FIRST_LOCATION));
        Assert.assertTrue((boolean)this.result.getValidatedLocations().contains(SECOND_LOCATION));
        Assert.assertNotNull((Object)this.result.getAllValidationChecksForLocation(FIRST_LOCATION));
        Assert.assertTrue((this.result.getAllValidationChecksForLocation(FIRST_LOCATION).size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.result.getAllValidationChecksForLocation(SECOND_LOCATION));
        Assert.assertTrue((this.result.getAllValidationChecksForLocation(SECOND_LOCATION).size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.result.getFailures(FIRST_LOCATION));
        Assert.assertTrue((this.result.getFailures(FIRST_LOCATION).size() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.result.getFailures(SECOND_LOCATION));
        Assert.assertTrue((this.result.getFailures(SECOND_LOCATION).size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void shouldHaveNoMetricsInitially() {
        Assert.assertEquals(Collections.emptyList(), (Object)this.result.getMetrics(FIRST_LOCATION));
    }

    @Test
    public void shouldTrackValidationMetrics() {
        this.result.setLocation(FIRST_LOCATION);
        this.result.addMetric("name", "value");
        Assert.assertEquals(Arrays.asList(new ValidationMetric("name", "value", NOW.getMillis())), (Object)this.result.getMetrics(FIRST_LOCATION));
        Assert.assertEquals(Collections.emptyList(), (Object)this.result.getMetrics(SECOND_LOCATION));
    }

    @Test
    public void should_keep_checks_from_target_result() {
        ValidationResult source = new ValidationResult();
        this.result.rejectForLocation(FIRST_LOCATION, "existing", new String[]{"param"});
        this.result.addAll(source);
        Assert.assertEquals((long)1L, (long)this.result.getFailures(FIRST_LOCATION).size());
        Assert.assertEquals((Object)"existing", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(0)).getKey());
    }

    @Test
    public void should_copy_checks_from_source_result() {
        ValidationResult source = new ValidationResult();
        source.rejectForLocation(FIRST_LOCATION, "added", new String[]{"param"});
        this.result.addAll(source);
        Assert.assertEquals((long)1L, (long)this.result.getFailures(FIRST_LOCATION).size());
        Assert.assertEquals((Object)"added", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(0)).getKey());
    }

    @Test
    public void should_add_all_checks_from_both_results() {
        ValidationResult source = new ValidationResult();
        source.rejectForLocation(FIRST_LOCATION, "added", new String[]{"param"});
        this.result.rejectForLocation(FIRST_LOCATION, "existing", new String[]{"param"});
        this.result.addAll(source);
        Assert.assertEquals((long)2L, (long)this.result.getFailures(FIRST_LOCATION).size());
        Assert.assertEquals((Object)"existing", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(0)).getKey());
        Assert.assertEquals((Object)"added", (Object)((ValidationCheck)this.result.getFailures(FIRST_LOCATION).get(1)).getKey());
    }
}

