/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.serialization;

import com.thoughtworks.xstream.converters.Converter;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.serialization.ProvisioningCmsObjectXstreamConverter;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import net.ripe.rpki.commons.xml.XStreamXmlSerializerBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningCmsObjectXstreamConverterTest {
    private XStreamXmlSerializer<ProvisioningCmsObject> serializer;

    @Before
    public void given() {
        XStreamXmlSerializerBuilder xStreamXmlSerializerBuilder = new XStreamXmlSerializerBuilder(ProvisioningCmsObject.class);
        xStreamXmlSerializerBuilder.withConverter((Converter)new ProvisioningCmsObjectXstreamConverter());
        xStreamXmlSerializerBuilder.withAliasType("ProvisioningCmsObject", ProvisioningCmsObject.class);
        this.serializer = xStreamXmlSerializerBuilder.build();
    }

    @Test
    public void shouldRoundTrip() {
        ProvisioningCmsObject cmsObject = ProvisioningObjectMother.createResourceClassListQueryProvisioningCmsObject();
        String xml = this.serializer.serialize((Object)cmsObject);
        ProvisioningCmsObject deserializedCmsObject = (ProvisioningCmsObject)this.serializer.deserialize(xml);
        Assert.assertEquals((Object)cmsObject, (Object)deserializedCmsObject);
    }

    @Test
    public void shouldUseSimpleXml() {
        ProvisioningCmsObject cmsObject = ProvisioningObjectMother.createResourceClassListQueryProvisioningCmsObject();
        String xml = this.serializer.serialize((Object)cmsObject);
        String expectedRegex = "<ProvisioningCmsObject>\n  <encoded>[^<]*</encoded>\n</ProvisioningCmsObject>";
        Assert.assertTrue((boolean)Pattern.matches(expectedRegex, xml));
    }
}

