/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.interop;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.cms.CMSException;
import org.junit.Assert;
import org.junit.Test;

public class ProcessApnicPdusTest {
    private static final String PATH_TO_TEST_PDUS = "src/test/resources/apnic-interop";

    @Test
    public void apnic_pdu_2011_08_15_1_has_errors() throws IOException, CMSException {
        byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/apnic-interop/A971C.1"));
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("cms", encoded);
        ValidationResult validationResult = parser.getValidationResult();
        Set failures = validationResult.getFailuresForCurrentLocation();
        Assert.assertTrue((String)"Should have 1 failure", (failures.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cms.only.one.crl", (Object)((ValidationCheck)failures.iterator().next()).getKey());
    }

    @Test
    public void apnic_pdu_2011_08_15_3_has_errors() throws IOException, CMSException {
        byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/apnic-interop/A971C.3"));
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("cms", encoded);
        ValidationResult validationResult = parser.getValidationResult();
        Set failures = validationResult.getFailuresForCurrentLocation();
        Assert.assertTrue((String)"Should have 1 failure", (failures.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cms.only.one.crl", (Object)((ValidationCheck)failures.iterator().next()).getKey());
    }

    private void prettyPrintFailures(ValidationResult validationResult) {
        for (ValidationLocation location : validationResult.getValidatedLocations()) {
            for (ValidationCheck failure : validationResult.getFailures(location)) {
                System.err.println(location + "\t" + failure + "\n");
            }
        }
    }
}

