/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectParserException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CertificateRepositoryObjectFactoryTest {
    private ValidationResult validationResult;

    @Before
    public void setUp() {
        this.validationResult = new ValidationResult();
    }

    @Test(expected=CertificateRepositoryObjectParserException.class)
    public void shouldNotParseIllegalByteString() {
        byte[] encoded = new byte[]{0};
        CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)this.validationResult);
    }

    @Test
    public void shoudParseResourceCertificate() {
        X509ResourceCertificate cert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])cert.getEncoded(), (ValidationResult)this.validationResult);
        Assert.assertEquals((Object)cert, (Object)object);
        Assert.assertTrue((boolean)this.validationResult.getResult(this.validationResult.getCurrentLocation(), "cert.public.key.size").isOk());
    }

    @Test
    public void shouldParseRoaCms() {
        RoaCms roaCms = RoaCmsTest.getRoaCms();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])roaCms.getEncoded(), (ValidationResult)this.validationResult);
        Assert.assertEquals((Object)roaCms, (Object)object);
    }

    @Test
    public void shouldParseManifestCms() {
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])manifestCms.getEncoded(), (ValidationResult)this.validationResult);
        Assert.assertEquals((Object)manifestCms, (Object)object);
    }

    @Test
    public void shouldParseCrl() {
        X509Crl crl = X509CrlTest.createCrl();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])crl.getEncoded(), (ValidationResult)this.validationResult);
        Assert.assertEquals((Object)crl, (Object)object);
    }
}

