/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoderTest;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.junit.Assert;
import org.junit.Test;

public class Asn1UtilTest {
    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseNonZeroPadBits() {
        byte[] WRONG_ENCODED_IPV4_10_5_0_0_23 = new byte[]{3, 4, 1, 10, 5, 1};
        Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])WRONG_ENCODED_IPV4_10_5_0_0_23));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIPv4ParsingWhenNoValidDerBitStringFoundP() {
        byte[] WRONG_ENCODED_IPV4_10_5_0_0_23 = new byte[]{5, 4, 1, 10, 5, 1};
        Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])WRONG_ENCODED_IPV4_10_5_0_0_23));
    }

    @Test
    public void shouldParseIpv4Address() {
        Assert.assertEquals((Object)IpResource.parse((String)"0.0.0.0/0"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_0_0_0_0_0)));
        Assert.assertEquals((Object)IpResource.parse((String)"10.5.0.4/32"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_10_5_0_4_32)));
        Assert.assertEquals((Object)IpResource.parse((String)"10.5.0.0/23"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_10_5_0_0_23)));
        Assert.assertEquals((Object)IpResource.parse((String)"10.64.0.0/12"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_10_64_0_0_12)));
        Assert.assertEquals((Object)IpResource.parse((String)"10.64.0.0/20"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_10_64_0_0_20)));
        Assert.assertEquals((Object)IpResource.parse((String)"128.5.0.4/32"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_128_5_0_4_32)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseNonZeroPadBitsIpv4Address() {
        byte[] WRONG_ENCODED_IPV4_10_5_0_0 = new byte[]{3, 3, 1, 10, 5};
        Asn1Util.parseIpAddress((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])WRONG_ENCODED_IPV4_10_5_0_0), (boolean)false);
    }

    @Test
    public void shouldParseIpv6Addresses() {
        Assert.assertEquals((Object)IpResource.parse((String)"2001:0:200:3::1/128"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv6, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV6_2001_0_200_3_0_0_0_1_128)));
        Assert.assertEquals((Object)IpResource.parse((String)"2001:0:200::/39"), (Object)Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv6, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV6_2001_0_200_39)));
    }

    @Test
    public void shouldEncodeIpv4Address() {
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV4_10_5_0_4_32, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"10.5.0.4/32")));
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV4_128_5_0_4_32, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"128.5.0.4/32")));
    }

    @Test
    public void shouldEncodeIpv4Prefix() {
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV4_0_0_0_0_0, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"0.0.0.0/0")));
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV4_10_5_0_0_23, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"10.5.0.0/23")));
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV4_10_64_0_0_12, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"10.64.0.0/12")));
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV4_10_64_0_0_20, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"10.64.0.0/20")));
    }

    @Test
    public void shouldEncodeIpv6Address() {
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV6_2001_0_200_3_0_0_0_1_128, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"2001:0:200:3:0:0:0:1/128")));
    }

    @Test
    public void shouldEncodeIpv6Prefix() {
        Asn1UtilTest.assertEncoded(ResourceExtensionEncoderTest.ENCODED_IPV6_2001_0_200_39, (ASN1Encodable)Asn1Util.encodeIpAddress((IpRange)IpRange.parse((String)"2001:0:200::/39")));
    }

    @Test
    public void shouldDecodeAsn() {
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_0, (Object)Asn1Util.parseAsId((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_0)));
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_127, (Object)Asn1Util.parseAsId((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_127)));
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_128, (Object)Asn1Util.parseAsId((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_128)));
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_412_233, (Object)Asn1Util.parseAsId((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_412_233)));
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_65535_65535, (Object)Asn1Util.parseAsId((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_65535_65535)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnOutOfRangeAsn() {
        Asn1Util.parseAsId((ASN1Encodable)new ASN1Integer(-1));
    }

    @Test
    public void HandleZeroSlashEight() {
        String expected = "0.12.0.0";
        Ipv4Address ip = Ipv4Address.parse((String)expected);
        int bits = 16;
        DERBitString bitString = Asn1Util.resourceToBitString((UniqueIpResource)ip, (int)bits);
        IpRange ipAfter = Asn1Util.parseIpAddressAsPrefix((IpResourceType)IpResourceType.IPv4, (ASN1Encodable)bitString);
        String actual = ipAfter.toString();
        Assert.assertEquals((String)"The ip addresses should not have mutated!", (Object)(expected + "/16"), (Object)actual);
    }

    public static void assertEncoded(byte[] expected, ASN1Encodable encodable) {
        byte[] actual = Asn1Util.encode((ASN1Encodable)encodable);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }
}

