/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import java.util.SortedMap;
import java.util.TreeMap;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoderTest;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionParser;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceExtensionParserTest {
    ResourceExtensionParser parser;

    @Before
    public void setUp() {
        this.parser = new ResourceExtensionParser();
    }

    @Test
    public void shouldParseIpv4Range() {
        Assert.assertEquals((Object)IpResource.parse((String)"10.5.0.0-10.5.1.255"), (Object)this.parser.derToIpRange(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_RANGE_10_5_0_0_TO_10_5_1_255)));
        Assert.assertEquals((Object)IpResource.parse((String)"0.0.0.0-255.255.255.255"), (Object)this.parser.derToIpRange(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_RANGE_0_0_0_0_TO_255_255_255_255)));
        Assert.assertEquals((Object)IpResource.parse((String)"10.5.4.0-10.5.15.255"), (Object)this.parser.derToIpRange(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_RANGE_10_5_4_0_TO_10_5_15_255)));
        Assert.assertEquals((Object)IpResource.parse((String)"128.5.4.0-128.5.15.255"), (Object)this.parser.derToIpRange(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_RANGE_128_5_4_0_TO_128_5_15_255)));
    }

    @Test
    public void shouldParseIpv6Range() {
        Assert.assertEquals((Object)IpResource.parse((String)"2001:0:200::-2001:0:3ff:ffff:ffff:ffff:ffff:ffff"), (Object)this.parser.derToIpRange(IpResourceType.IPv6, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV6_RANGE_2001_0_200__TO_2001_0_3FF_FFFF_FFFF_FFFF_FFFF_FFFF)));
    }

    @Test
    public void shouldParseIpv4AddressOrRange() {
        Assert.assertEquals((Object)IpResource.parse((String)"10.5.0.0-10.5.1.255"), (Object)this.parser.derToIpAddressOrRange(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_RANGE_10_5_0_0_TO_10_5_1_255)));
        Assert.assertEquals((Object)IpResource.parse((String)"0.0.0.0/0"), (Object)this.parser.derToIpAddressOrRange(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_0_0_0_0_0)));
    }

    @Test
    public void shouldParseIpv6AddressOrRange() {
        Assert.assertEquals((Object)IpResource.parse((String)"2001:0:200::-2001:0:3ff:ffff:ffff:ffff:ffff:ffff"), (Object)this.parser.derToIpAddressOrRange(IpResourceType.IPv6, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV6_RANGE_2001_0_200__TO_2001_0_3FF_FFFF_FFFF_FFFF_FFFF_FFFF)));
        Assert.assertEquals((Object)IpResource.parse((String)"2001:0:200::/39"), (Object)this.parser.derToIpAddressOrRange(IpResourceType.IPv6, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV6_2001_0_200_39)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnIllegalIpAddressOrRange() {
        this.parser.derToIpAddressOrRange(IpResourceType.IPv4, (ASN1Encodable)new ASN1Integer(123));
    }

    @Test
    public void shouldParseIpv4AddressChoice() {
        IpResourceSet ipResourceSet = new IpResourceSet();
        ipResourceSet.add(IpResource.parse((String)"10.5.4.0-10.5.15.255"));
        ipResourceSet.add(IpResource.parse((String)"128.5.0.4/32"));
        Assert.assertEquals((Object)ipResourceSet, (Object)this.parser.derToIpAddressChoice(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_RESOURCES)));
    }

    @Test
    public void shouldParseNullAsIpv4AddressChoice() {
        Assert.assertNull((Object)this.parser.derToIpAddressChoice(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_NULL)));
    }

    @Test
    public void shouldParseIpAddressFamily() {
        IpResourceSet ipResourceSet = new IpResourceSet();
        ipResourceSet.add(IpResource.parse((String)"10.5.4.0-10.5.15.255"));
        ipResourceSet.add(IpResource.parse((String)"128.5.0.4/32"));
        TreeMap<AddressFamily, IpResourceSet> map = new TreeMap<AddressFamily, IpResourceSet>();
        TreeMap map2 = new TreeMap();
        map.put(AddressFamily.IPV4, ipResourceSet);
        this.parser.derToIpAddressFamily((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_IPV4_ADDRESS_FAMILY_RESOURCES), map2);
        Assert.assertEquals(map, map2);
    }

    @Test
    public void shouldParseRfc3779AppendixBFirstExample() {
        TreeMap<AddressFamily, IpResourceSet> resources = new TreeMap<AddressFamily, IpResourceSet>();
        resources.put(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(1)), IpResourceSet.parse((String)"10.0.32.0/20, 10.0.64.0/24, 10.1.0.0/16, 10.2.48.0/20, 10.2.64.0/24, 10.3.0.0/16"));
        resources.put(AddressFamily.IPV6, null);
        Assert.assertEquals(resources, (Object)this.parser.derToIpAddressBlocks((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.RFC3779_APPENDIX_B_EXAMPLE_1)));
    }

    @Test
    public void shouldParseRfc3779AppendixBSecondExample() {
        TreeMap<AddressFamily, IpResourceSet> resources = new TreeMap<AddressFamily, IpResourceSet>();
        resources.put(AddressFamily.IPV6, IpResourceSet.parse((String)"2001:0:2::/48"));
        resources.put(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(1)), IpResourceSet.parse((String)"10.0.0.0/8,176.16.0.0/12"));
        resources.put(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(2)), null);
        Assert.assertEquals(resources, (Object)this.parser.derToIpAddressBlocks((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.RFC3779_APPENDIX_B_EXAMPLE_2)));
    }

    @Test
    public void shouldParseExtensionWithoutNullSetsToIpResourceSet() {
        IpResourceSet ipv4ResourceSet = IpResourceSet.parse((String)"10.5.4.0-10.5.15.255, 128.5.0.4/32");
        IpResourceSet ipv6ResourceSet = IpResourceSet.parse((String)"2001:0:200::/39");
        SortedMap parsed = this.parser.parseIpAddressBlocks(ResourceExtensionEncoderTest.ENCODED_IP_ADDRESS_BLOCKS_EXTENSION);
        Assert.assertEquals((Object)ipv4ResourceSet, parsed.get(AddressFamily.IPV4));
        Assert.assertEquals((Object)ipv6ResourceSet, parsed.get(AddressFamily.IPV6));
    }

    @Test
    public void shouldSupportIpv4OnlyInheritance() {
        SortedMap parsed = this.parser.parseIpAddressBlocks(ResourceExtensionEncoderTest.ENCODED_IPV4_ONLY_INHERITED);
        Assert.assertTrue((parsed.containsKey(AddressFamily.IPV4) && parsed.get(AddressFamily.IPV4) == null ? 1 : 0) != 0);
        Assert.assertNotNull(parsed.get(AddressFamily.IPV6));
    }

    @Test
    public void shouldSupportIpv4AndIpv6Inheritance() {
        SortedMap parsed = this.parser.parseIpAddressBlocks(ResourceExtensionEncoderTest.ENCODED_IPV4_AND_IPV6_INHERITED);
        Assert.assertTrue((parsed.containsKey(AddressFamily.IPV4) && parsed.get(AddressFamily.IPV4) == null ? 1 : 0) != 0);
        Assert.assertTrue((parsed.containsKey(AddressFamily.IPV6) && parsed.get(AddressFamily.IPV6) == null ? 1 : 0) != 0);
    }

    @Test
    public void shouldSupportAsIdentifierInheritance() {
        Assert.assertNull((Object)this.parser.parseAsIdentifiers(ResourceExtensionEncoderTest.ENCODED_AS_IDENTIFIERS_INHERITED));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseExtensionWithNullSet() {
        this.parser.parseIpAddressBlocks(ResourceExtensionEncoderTest.RFC3779_APPENDIX_B_EXAMPLE_1);
    }

    @Test
    public void shouldDecodeAsRange() {
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_127.upTo((UniqueIpResource)ResourceExtensionEncoderTest.ASN_128), (Object)this.parser.derToAsRange((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_127_TO_128)));
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_0.upTo((UniqueIpResource)ResourceExtensionEncoderTest.ASN_65535_65535), (Object)this.parser.derToAsRange((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_0_TO_65535_65535)));
    }

    @Test
    public void shouldDecodeAsIdOrRange() {
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_127, (Object)this.parser.derToAsIdOrRange((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_127)));
        Assert.assertEquals((Object)ResourceExtensionEncoderTest.ASN_127.upTo((UniqueIpResource)ResourceExtensionEncoderTest.ASN_128), (Object)this.parser.derToAsIdOrRange((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_ASN_127_TO_128)));
    }

    @Test
    public void shouldDecodeAsIdsOrRanges() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{ResourceExtensionEncoderTest.ASN_412_233, ResourceExtensionEncoderTest.ASN_127.upTo((UniqueIpResource)ResourceExtensionEncoderTest.ASN_128)});
        Assert.assertEquals((Object)resources, (Object)this.parser.derToAsIdsOrRanges((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_AS_IDS_OR_RANGES)));
    }

    @Test
    public void shouldDecodeAsIdentifierChoice() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{ResourceExtensionEncoderTest.ASN_412_233, ResourceExtensionEncoderTest.ASN_127.upTo((UniqueIpResource)ResourceExtensionEncoderTest.ASN_128)});
        Assert.assertNull((Object)this.parser.derToAsIdentifierChoice((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_NULL)));
        Assert.assertEquals((Object)resources, (Object)this.parser.derToAsIdentifierChoice((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.ENCODED_AS_IDS_OR_RANGES)));
    }

    @Test
    public void shouldDecodeRfc3779AppendixCExample() {
        IpResourceSet asnResources = IpResourceSet.parse((String)"AS135, AS3000-AS3999, AS5001");
        IpResourceSet[] result = this.parser.derToAsIdentifiers((ASN1Encodable)Asn1Util.decode((byte[])ResourceExtensionEncoderTest.RFC3779_APPENDIX_C_EXAMPLE));
        Assert.assertEquals((Object)asnResources, (Object)result[0]);
        Assert.assertNull((Object)result[1]);
    }

    @Test
    public void shouldDecodeAsIdentifiers() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{ResourceExtensionEncoderTest.ASN_412_233, ResourceExtensionEncoderTest.ASN_127.upTo((UniqueIpResource)ResourceExtensionEncoderTest.ASN_128)});
        Assert.assertEquals((Object)resources, (Object)this.parser.parseAsIdentifiers(ResourceExtensionEncoderTest.ENCODED_AS_IDENTIFIERS_EXTENSION));
    }
}

