/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.rsync.ProcessReaderException;

public class ProcessReader
extends Thread {
    private InputStream input;
    private OutputStream output;
    private List<String> lines;

    public ProcessReader(InputStream input) {
        this.input = input;
    }

    public ProcessReader(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public void run() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));
            PrintWriter printer = null;
            if (this.output == null) {
                this.lines = new ArrayList<String>();
            } else {
                printer = new PrintWriter(this.output);
            }
            while ((line = reader.readLine()) != null) {
                if (this.output == null) {
                    this.lines.add(line);
                    continue;
                }
                printer.println(line);
                printer.flush();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ProcessReaderException(e);
        }
    }
}

