/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509.pkcs10;

import java.io.IOException;
import java.net.URI;
import java.security.KeyPair;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestBuilderException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class RpkiCaCertificateRequestBuilder {
    private X500Principal subject;
    private URI caRepositoryUri;
    private URI manifestUri;
    private String signatureAlgorithm = "SHA256withRSA";
    private String signatureProvider = "SunRsaSign";

    public RpkiCaCertificateRequestBuilder withSubject(X500Principal subject) {
        this.subject = subject;
        return this;
    }

    public RpkiCaCertificateRequestBuilder withCaRepositoryUri(URI caRepositoryUri) {
        this.caRepositoryUri = caRepositoryUri;
        return this;
    }

    public RpkiCaCertificateRequestBuilder withManifestUri(URI manifestUri) {
        this.manifestUri = manifestUri;
        return this;
    }

    public RpkiCaCertificateRequestBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public RpkiCaCertificateRequestBuilder withSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public PKCS10CertificationRequest build(KeyPair keyPair) {
        try {
            Extensions extensions = this.createExtensions();
            ContentSigner signer = new JcaContentSignerBuilder(this.signatureAlgorithm).setProvider(this.signatureProvider).build(keyPair.getPrivate());
            JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(this.subject, keyPair.getPublic());
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensions);
            return builder.build(signer);
        }
        catch (Exception e) {
            throw new RpkiCaCertificateRequestBuilderException(e);
        }
    }

    private Extensions createExtensions() throws IOException {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        X509CertificateInformationAccessDescriptor[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, this.caRepositoryUri), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, this.manifestUri)};
        AccessDescription[] subjectInformationAccess = X509CertificateInformationAccessDescriptor.convertAccessDescriptors(descriptors);
        DERSequence derSequence = new DERSequence((ASN1Encodable[])subjectInformationAccess);
        extensions.add(new Extension(Extension.subjectInfoAccess, false, (ASN1OctetString)new DEROctetString(derSequence.getEncoded())));
        KeyUsage keyUsage = new KeyUsage(6);
        extensions.add(new Extension(Extension.keyUsage, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)keyUsage)));
        extensions.add(new Extension(Extension.basicConstraints, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)new BasicConstraints(true))));
        return new Extensions(extensions.toArray(new Extension[extensions.size()]));
    }
}

