/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.payload.common.GenericClassElement;
import net.ripe.rpki.commons.provisioning.payload.common.ResourceClassUtil;
import net.ripe.rpki.commons.provisioning.payload.issue.response.CertificateIssuanceResponseClassElement;
import net.ripe.rpki.commons.provisioning.payload.list.response.ResourceClassListResponseClassElement;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class GenericClassElementBuilder {
    private String className;
    private List<URI> certificateAuthorityUri = new ArrayList<URI>();
    private IpResourceSet ipResourceSet;
    private DateTime validityNotAfter;
    private String siaHeadUri;
    private List<CertificateElement> certificateElements = new ArrayList<CertificateElement>();
    private X509ResourceCertificate issuer;

    public GenericClassElementBuilder withValidityNotAfter(DateTime notAfter) {
        this.validityNotAfter = notAfter;
        return this;
    }

    public GenericClassElementBuilder withSiaHeadUri(String siaHead) {
        this.siaHeadUri = siaHead;
        return this;
    }

    public GenericClassElementBuilder withClassName(String className) {
        this.className = className;
        return this;
    }

    public GenericClassElementBuilder withIpResourceSet(IpResourceSet ipResourceSet) {
        this.ipResourceSet = ipResourceSet;
        return this;
    }

    public GenericClassElementBuilder withCertificateAuthorityUri(List<URI> caUri) {
        this.certificateAuthorityUri = caUri;
        return this;
    }

    public GenericClassElementBuilder withCertificateElements(List<CertificateElement> certificateElements) {
        this.certificateElements = certificateElements;
        return this;
    }

    public GenericClassElementBuilder withIssuer(X509ResourceCertificate issuer) {
        this.issuer = issuer;
        return this;
    }

    private void validateFields() {
        Validate.notNull((Object)this.className, (String)"No className provided");
        boolean rsyncUriFound = ResourceClassUtil.hasRsyncUri(this.certificateAuthorityUri);
        Validate.isTrue((boolean)rsyncUriFound, (String)"No RSYNC URI provided");
        Validate.notNull((Object)this.issuer, (String)"issuer certificate is required");
        Validate.notNull((Object)this.validityNotAfter, (String)"Validity not after is required");
        Validate.isTrue((boolean)this.validityNotAfter.getZone().equals((Object)DateTimeZone.UTC), (String)"Validity time must be in UTC timezone");
    }

    public ResourceClassListResponseClassElement buildResourceClassListResponseClassElement() {
        this.validateFields();
        ResourceClassListResponseClassElement classElement = new ResourceClassListResponseClassElement();
        this.setGenericClassElementFields(classElement);
        classElement.setCertificateElements(this.certificateElements);
        return classElement;
    }

    public CertificateIssuanceResponseClassElement buildCertificateIssuanceResponseClassElement() {
        this.validateFields();
        Validate.isTrue((this.certificateElements.size() == 1 ? 1 : 0) != 0);
        CertificateIssuanceResponseClassElement classElement = new CertificateIssuanceResponseClassElement();
        this.setGenericClassElementFields(classElement);
        classElement.setCertificateElement(this.certificateElements.get(0));
        return classElement;
    }

    private void setGenericClassElementFields(GenericClassElement classElement) {
        classElement.setClassName(this.className);
        classElement.setCertUris(this.certificateAuthorityUri);
        classElement.setIpResourceSet(this.ipResourceSet);
        classElement.setIssuer(this.issuer);
        classElement.setValidityNotAfter(this.validityNotAfter);
        classElement.setSiaHeadUri(this.siaHeadUri);
    }
}

