/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilderException;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.PayloadParser;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cert.jcajce.JcaCRLStore;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.Store;
import org.joda.time.DateTimeUtils;

public class ProvisioningCmsObjectBuilder {
    private static final ASN1ObjectIdentifier CONTENT_TYPE = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.28");
    private X509Certificate cmsCertificate;
    private X509Certificate[] caCertificates;
    private X509CRL crl;
    private String signatureProvider = "SunRsaSign";
    private String payloadContent;

    public ProvisioningCmsObjectBuilder withCmsCertificate(X509Certificate cmsCertificate) {
        this.cmsCertificate = cmsCertificate;
        return this;
    }

    public ProvisioningCmsObjectBuilder withCrl(X509CRL crl) {
        this.crl = crl;
        return this;
    }

    public ProvisioningCmsObjectBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public ProvisioningCmsObjectBuilder withPayloadContent(AbstractProvisioningPayload payload) {
        this.payloadContent = PayloadParser.serialize(payload);
        return this;
    }

    public ProvisioningCmsObject build(PrivateKey privateKey) {
        Validate.notEmpty((String)this.payloadContent, (String)"Payload content is required");
        Validate.notNull((Object)this.cmsCertificate, (String)"cms certificate is required");
        Validate.notNull((Object)this.crl, (String)"crl is required");
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("generated.cms", this.generateCms(privateKey));
        ValidationResult validationResult = parser.getValidationResult();
        if (validationResult.hasFailures()) {
            ArrayList<String> failureMessages = new ArrayList<String>();
            List<ValidationCheck> failures = validationResult.getFailures(new ValidationLocation("generated.cms"));
            for (ValidationCheck check : failures) {
                failureMessages.add(check.getKey());
            }
            Validate.isTrue((boolean)false, (String)("Validation of generated CMS object failed with following errors: " + StringUtils.join(failureMessages, (String)",")));
        }
        return parser.getProvisioningCmsObject();
    }

    private byte[] generateCms(PrivateKey privateKey) {
        try {
            return this.doGenerate(privateKey);
        }
        catch (CMSException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
        catch (IOException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
        catch (OperatorCreationException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
        catch (CRLException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
        catch (CertificateEncodingException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
    }

    private byte[] doGenerate(PrivateKey privateKey) throws CMSException, IOException, CertificateEncodingException, CRLException, OperatorCreationException {
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        this.addCertificateAndCrl(generator);
        this.addSignerInfo(generator, privateKey);
        CMSSignedData data = generator.generate((CMSTypedData)new CMSProcessableByteArray(CONTENT_TYPE, this.payloadContent.getBytes(Charset.forName("UTF-8"))), true);
        return data.getEncoded();
    }

    private void addSignerInfo(CMSSignedDataGenerator generator, PrivateKey privateKey) throws OperatorCreationException {
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(this.signatureProvider).build(privateKey);
        DigestCalculatorProvider digestProvider = BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER;
        SignerInfoGenerator gen = new JcaSignerInfoGeneratorBuilder(digestProvider).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(this.createSignedAttributes())).build(signer, X509CertificateUtil.getSubjectKeyIdentifier(this.cmsCertificate));
        generator.addSignerInfoGenerator(gen);
    }

    private void addCertificateAndCrl(CMSSignedDataGenerator generator) throws CertificateEncodingException, CMSException, CRLException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        certificates.add(this.cmsCertificate);
        if (this.caCertificates != null) {
            certificates.addAll(Arrays.asList(this.caCertificates));
        }
        generator.addCertificates((Store)new JcaCertStore(certificates));
        generator.addCRLs((Store)new JcaCRLStore(Collections.singleton(this.crl)));
    }

    private AttributeTable createSignedAttributes() {
        Hashtable<ASN1ObjectIdentifier, Attribute> attributes = new Hashtable<ASN1ObjectIdentifier, Attribute>();
        Attribute signingTimeAttribute = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(new Date(DateTimeUtils.currentTimeMillis()))));
        attributes.put(CMSAttributes.signingTime, signingTimeAttribute);
        return new AttributeTable(attributes);
    }
}

