/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.StoreException;

public class BouncyCastleUtil {
    private static final JcaX509ExtensionUtils JCA_X509_EXTENSION_UTILS;
    public static final DigestCalculatorProvider DIGEST_CALCULATOR_PROVIDER;

    private BouncyCastleUtil() {
    }

    public static AuthorityKeyIdentifier createAuthorityKeyIdentifier(PublicKey publicKey) {
        return JCA_X509_EXTENSION_UTILS.createAuthorityKeyIdentifier(publicKey);
    }

    public static SubjectKeyIdentifier createSubjectKeyIdentifier(PublicKey publicKey) {
        return JCA_X509_EXTENSION_UTILS.createSubjectKeyIdentifier(publicKey);
    }

    public static X500Name principalToName(X500Principal dn) {
        return X500Name.getInstance((Object)dn.getEncoded());
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(PublicKey key) {
        return SubjectPublicKeyInfo.getInstance((Object)key.getEncoded());
    }

    public static X509Certificate holderToCertificate(X509CertificateHolder holder) throws CertificateException {
        return new JcaX509CertificateConverter().getCertificate(holder);
    }

    public static List<? extends X509Certificate> extractCertificates(CMSSignedDataParser signedDataParser) throws StoreException, CMSException, CertificateException {
        Collection holders = signedDataParser.getCertificates().getMatches((Selector)new X509CertificateHolderStoreSelector());
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (X509CertificateHolder holder : holders) {
            result.add(BouncyCastleUtil.holderToCertificate(holder));
        }
        return result;
    }

    public static X509CRL holderToCrl(X509CRLHolder holder) throws CRLException {
        return new JcaX509CRLConverter().getCRL(holder);
    }

    public static List<? extends X509CRL> extractCrls(CMSSignedDataParser signedDataParser) throws StoreException, CMSException, CRLException {
        Collection holders = signedDataParser.getCRLs().getMatches((Selector)new X509CRLHolderStoreSelector());
        ArrayList<X509CRL> result = new ArrayList<X509CRL>();
        for (X509CRLHolder holder : holders) {
            result.add(BouncyCastleUtil.holderToCrl(holder));
        }
        return result;
    }

    static {
        try {
            JCA_X509_EXTENSION_UTILS = new JcaX509ExtensionUtils();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        DIGEST_CALCULATOR_PROVIDER = new BcDigestCalculatorProvider();
    }

    public static final class X509CertificateHolderStoreSelector
    implements Selector {
        public boolean match(Object obj) {
            return obj instanceof X509CertificateHolder;
        }

        public Object clone() {
            return this;
        }
    }

    public static final class X509CRLHolderStoreSelector
    implements Selector {
        public boolean match(Object obj) {
            return obj instanceof X509CRLHolder;
        }

        public Object clone() {
            return this;
        }
    }
}

