/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectBuilder;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationLocation;
import org.apache.commons.lang.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;

public class RoaCmsBuilder
extends RpkiSignedObjectBuilder {
    private X509ResourceCertificate certificate;
    private Asn asn;
    private List<RoaPrefix> prefixes;
    private String signatureProvider;

    public RoaCmsBuilder withCertificate(X509ResourceCertificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public RoaCmsBuilder withAsn(Asn asn) {
        this.asn = asn;
        return this;
    }

    public RoaCmsBuilder withPrefixes(List<RoaPrefix> prefixes) {
        this.prefixes = prefixes;
        return this;
    }

    public RoaCmsBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public RoaCms build(PrivateKey privateKey) {
        RoaCmsParser parser = new RoaCmsParser();
        parser.parse(new ValidationLocation("generated.roa"), this.generateCms(this.certificate.getCertificate(), privateKey, this.signatureProvider, RoaCms.CONTENT_TYPE, this.encodeRouteOriginAttestation(this.asn, this.prefixes)));
        return parser.getRoaCms();
    }

    ASN1Object encodeRoaIpAddress(RoaPrefix prefix) {
        DERBitString address = Asn1Util.resourceToBitString(prefix.getPrefix().getStart(), prefix.getPrefix().getPrefixLength());
        ASN1Encodable[] encodables = prefix.getMaximumLength() == null ? new ASN1Encodable[]{address} : new ASN1Encodable[]{address, new ASN1Integer(prefix.getMaximumLength().intValue())};
        return new DERSequence(encodables);
    }

    ASN1Encodable encodeRoaIpAddressFamily(AddressFamily addressFamily, List<RoaPrefix> prefixes) {
        ASN1Encodable[] encodablesPrefixes = new ASN1Encodable[prefixes.size()];
        for (int i = 0; i < prefixes.size(); ++i) {
            encodablesPrefixes[i] = this.encodeRoaIpAddress(prefixes.get(i));
        }
        ASN1Encodable[] seq = new ASN1Encodable[]{addressFamily.toDer(), new DERSequence(encodablesPrefixes)};
        return new DERSequence(seq);
    }

    ASN1Encodable encodeRoaIpAddressFamilySequence(List<RoaPrefix> prefixes) {
        Validate.isTrue((!prefixes.isEmpty() ? 1 : 0) != 0, (String)"no prefixes");
        ArrayList<ASN1Encodable> encodables = new ArrayList<ASN1Encodable>(2);
        this.addRoaIpAddressFamily(encodables, IpResourceType.IPv4, prefixes);
        this.addRoaIpAddressFamily(encodables, IpResourceType.IPv6, prefixes);
        Validate.isTrue((!encodables.isEmpty() ? 1 : 0) != 0, (String)"no encodable prefixes");
        return new DERSequence(encodables.toArray(new ASN1Encodable[encodables.size()]));
    }

    private void addRoaIpAddressFamily(List<ASN1Encodable> encodables, IpResourceType type, List<RoaPrefix> prefixes) {
        List<RoaPrefix> selectedPrefixes = this.selectPrefixes(type, prefixes);
        if (!selectedPrefixes.isEmpty()) {
            encodables.add(this.encodeRoaIpAddressFamily(AddressFamily.fromIpResourceType(type), selectedPrefixes));
        }
    }

    private List<RoaPrefix> selectPrefixes(IpResourceType type, List<RoaPrefix> prefixes) {
        ArrayList<RoaPrefix> result = new ArrayList<RoaPrefix>();
        for (RoaPrefix roaPrefix : prefixes) {
            if (type != roaPrefix.getPrefix().getType()) continue;
            result.add(roaPrefix);
        }
        return result;
    }

    ASN1Encodable encodeRouteOriginAttestation(Asn asn, List<RoaPrefix> prefixes) {
        ASN1Encodable[] encodables = new ASN1Encodable[]{new ASN1Integer(asn.getValue()), this.encodeRoaIpAddressFamilySequence(prefixes)};
        return new DERSequence(encodables);
    }
}

