/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class X509CrlTest {
    private static final URI ROOT_MANIFEST_CRL_LOCATION = URI.create("rsync://foo.host/bar/bar%20space.crl");
    private static final ValidationOptions VALIDATION_OPTIONS = new ValidationOptions();

    public static X509Crl createCrl() {
        X509CrlBuilder builder = X509CrlTest.getCrlBuilder();
        return builder.build(KeyPairFactoryTest.TEST_KEY_PAIR.getPrivate());
    }

    public static X509CrlBuilder getCrlBuilder() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(new X500Principal("CN=issuer"));
        builder.withThisUpdateTime(new DateTime());
        builder.withNextUpdateTime(new DateTime().plusHours(8));
        builder.withNumber(BigInteger.TEN);
        builder.withAuthorityKeyIdentifier(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private X509Crl getCrlWithKeyPair(KeyPair keyPair) {
        X509CrlBuilder builder = X509CrlTest.getCrlBuilder();
        builder.withAuthorityKeyIdentifier(keyPair.getPublic());
        return builder.build(keyPair.getPrivate());
    }

    @Test
    public void shouldHaveAuthorityKeyIdentifier() {
        X509Crl crl = X509CrlTest.createCrl();
        Assert.assertArrayEquals((byte[])KeyPairUtil.getKeyIdentifier((PublicKey)KeyPairFactoryTest.TEST_KEY_PAIR.getPublic()), (byte[])crl.getAuthorityKeyIdentifier());
    }

    @Test
    public void shouldValidateCrl() {
        X509Crl subject = X509CrlTest.createCrl();
        ValidationResult result = new ValidationResult();
        CrlLocator crlLocator = (CrlLocator)EasyMock.createMock(CrlLocator.class);
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_MANIFEST_CRL_LOCATION, X509ResourceCertificateTest.createSelfSignedCaResourceCertificate());
        EasyMock.replay((Object[])new Object[]{crlLocator});
        subject.validate(ROOT_MANIFEST_CRL_LOCATION.toString(), context, crlLocator, VALIDATION_OPTIONS, result);
        EasyMock.verify((Object[])new Object[]{crlLocator});
        Assert.assertFalse((boolean)result.hasFailures());
    }

    @Test
    public void shouldNotValidateInvalidCrl() {
        X509Crl subject = this.getCrlWithKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        ValidationResult result = new ValidationResult();
        CrlLocator crlLocator = (CrlLocator)EasyMock.createMock(CrlLocator.class);
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_MANIFEST_CRL_LOCATION, X509ResourceCertificateTest.createSelfSignedCaResourceCertificate());
        EasyMock.replay((Object[])new Object[]{crlLocator});
        subject.validate(ROOT_MANIFEST_CRL_LOCATION.toString(), context, crlLocator, VALIDATION_OPTIONS, result);
        EasyMock.verify((Object[])new Object[]{crlLocator});
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertTrue((result.getValidatedLocations().size() == 1 ? 1 : 0) != 0);
        ValidationLocation rootMftCrlValidationLocation = new ValidationLocation(ROOT_MANIFEST_CRL_LOCATION);
        Assert.assertTrue((boolean)result.hasFailureForLocation(rootMftCrlValidationLocation));
        Assert.assertEquals((Object)"cert.crl.signature", (Object)((ValidationCheck)result.getFailures(rootMftCrlValidationLocation).get(0)).getKey());
    }
}

