/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParserTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoaCmsTest {
    public static final X500Principal TEST_DN = new X500Principal("CN=Test");
    public static final KeyPair TEST_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
    public static final URI TEST_ROA_LOCATION = URI.create("rsync://certificate/repository/filename.roa");
    private List<RoaPrefix> ipv4Prefixes;
    private List<RoaPrefix> allPrefixes;
    private IpResourceSet allResources;
    private RoaCms subject;

    @Before
    public void setUp() {
        this.ipv4Prefixes = new ArrayList<RoaPrefix>();
        this.ipv4Prefixes.add(RoaCmsParserTest.TEST_IPV4_PREFIX_1);
        this.ipv4Prefixes.add(RoaCmsParserTest.TEST_IPV4_PREFIX_2);
        this.allPrefixes = new ArrayList<RoaPrefix>(this.ipv4Prefixes);
        this.allPrefixes.add(RoaCmsParserTest.TEST_IPV6_PREFIX);
        this.allResources = new IpResourceSet();
        for (RoaPrefix prefix : this.allPrefixes) {
            this.allResources.add((IpResource)prefix.getPrefix());
        }
        this.subject = RoaCmsTest.createRoaCms(this.allPrefixes);
    }

    public static RoaCms createRoaCms(List<RoaPrefix> prefixes) {
        RoaCmsBuilder builder = new RoaCmsBuilder();
        builder.withCertificate(RoaCmsTest.createCertificate(prefixes)).withAsn(RoaCmsParserTest.TEST_ASN);
        builder.withPrefixes(prefixes);
        builder.withSignatureProvider("SunRsaSign");
        return builder.build(TEST_KEY_PAIR.getPrivate());
    }

    public static RoaCms getRoaCms() {
        RoaCmsTest roaCmsTest = new RoaCmsTest();
        roaCmsTest.setUp();
        return roaCmsTest.subject;
    }

    public static X509ResourceCertificate createCertificate(List<RoaPrefix> prefixes) {
        IpResourceSet resources = new IpResourceSet();
        for (RoaPrefix prefix : prefixes) {
            resources.add((IpResource)prefix.getPrefix());
        }
        X509ResourceCertificateBuilder builder = RoaCmsTest.createCertificateBuilder(resources);
        X509ResourceCertificate result = builder.build();
        return result;
    }

    private static X509ResourceCertificateBuilder createCertificateBuilder(IpResourceSet resources) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withIssuerDN(TEST_DN).withSubjectDN(TEST_DN).withSerial(BigInteger.TEN);
        builder.withPublicKey(TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(TEST_KEY_PAIR);
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)new DateTime().minusMinutes(1), (ReadableInstant)new DateTime().plusYears(1)));
        builder.withResources(resources);
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, TEST_ROA_LOCATION)});
        return builder;
    }

    @Test
    public void shouldGenerateRoaCms() {
        Assert.assertEquals((Object)RoaCmsParserTest.TEST_ASN, (Object)this.subject.getAsn());
        Assert.assertEquals(this.allPrefixes, (Object)this.subject.getPrefixes());
        Assert.assertEquals((Object)this.allResources, (Object)this.subject.getResources());
    }

    @Test
    public void shouldVerifySignature() {
        Assert.assertTrue((boolean)this.subject.signedBy(this.subject.getCertificate()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectCaCertificateInRoa() {
        X509ResourceCertificate caCert = RoaCmsTest.createCertificateBuilder(new IpResourceSet(new IpResource[]{RoaCmsParserTest.TEST_IPV4_PREFIX_1.getPrefix(), RoaCmsParserTest.TEST_IPV4_PREFIX_2.getPrefix(), RoaCmsParserTest.TEST_IPV6_PREFIX.getPrefix()})).withCa(true).build();
        this.subject = new RoaCmsBuilder().withAsn(RoaCmsParserTest.TEST_ASN).withPrefixes(this.allPrefixes).withCertificate(caCert).build(TEST_KEY_PAIR.getPrivate());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireSubjectKeyIdentifier() {
        X509ResourceCertificate cert = RoaCmsTest.createCertificateBuilder(new IpResourceSet(new IpResource[]{RoaCmsParserTest.TEST_IPV4_PREFIX_1.getPrefix(), RoaCmsParserTest.TEST_IPV4_PREFIX_2.getPrefix(), RoaCmsParserTest.TEST_IPV6_PREFIX.getPrefix()})).withSubjectKeyIdentifier(false).build();
        this.subject = new RoaCmsBuilder().withAsn(RoaCmsParserTest.TEST_ASN).withPrefixes(this.allPrefixes).withCertificate(cert).build(TEST_KEY_PAIR.getPrivate());
    }

    @Test
    public void shouldUseNotValidBeforeTimeForSigningTime() {
        RoaCms roaCms = RoaCmsTest.createRoaCms(this.allPrefixes);
        Assert.assertEquals((Object)roaCms.getCertificate().getValidityPeriod().getNotValidBefore(), (Object)roaCms.getSigningTime());
    }
}

