/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml;

import java.sql.Timestamp;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.util.VersionedId;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import net.ripe.rpki.commons.xml.XStreamXmlSerializerBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class XStreamXmlSerializerBuilderTest {
    @Test
    public void shouldCreateSerializer() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(String.class);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)"foo");
        Assert.assertEquals((Object)"<string>foo</string>", (Object)serializedData);
    }

    @Test
    public void shouldAliasCommonsPackage() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(ValidityPeriod.class);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new ValidityPeriod());
        Assert.assertEquals((Object)"<commons.ValidityPeriod/>", (Object)serializedData);
    }

    @Test
    public void shouldAliasIpResourceAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(IpResource.class);
        XStreamXmlSerializer serializer = builder.build();
        IpResource ipResource = IpResource.parse((String)"10/8");
        String serializedData = serializer.serialize((Object)ipResource);
        Assert.assertEquals((Object)"<resource>10.0.0.0/8</resource>", (Object)serializedData);
        Assert.assertEquals((Object)ipResource, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldAliasIpResourceSetAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(IpResourceSet.class);
        XStreamXmlSerializer serializer = builder.build();
        IpResourceSet ipResourceSet = IpResourceSet.parse((String)"10/8");
        String serializedData = serializer.serialize((Object)ipResourceSet);
        Assert.assertEquals((Object)"<resource-set>10.0.0.0/8</resource-set>", (Object)serializedData);
        Assert.assertEquals((Object)ipResourceSet, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldAliasDateTimeAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(DateTime.class);
        XStreamXmlSerializer serializer = builder.build();
        DateTime dateTime = new DateTime(2011, 1, 31, 13, 59, 59, 0, DateTimeZone.UTC);
        String serializedData = serializer.serialize((Object)dateTime);
        Assert.assertEquals((Object)"<datetime>2011-01-31T13:59:59Z</datetime>", (Object)serializedData);
        Assert.assertEquals((Object)dateTime, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertDateTimeFromTimeStamp() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(Timestamp.class);
        XStreamXmlSerializer serializer = builder.build();
        Timestamp timestamp = new Timestamp(new DateTime(2011, 1, 31, 13, 59, 59, 0, DateTimeZone.UTC).getMillis());
        String serializedData = serializer.serialize((Object)timestamp);
        Assert.assertEquals((Object)"<sql-timestamp>2011-01-31T13:59:59.000Z</sql-timestamp>", (Object)serializedData);
        Assert.assertEquals((Object)timestamp, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertDateTimeFromReadablePeriod() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(Period.class);
        XStreamXmlSerializer serializer = builder.build();
        DateTime now = new DateTime();
        Period period = new Period((ReadableInstant)now, (ReadableInstant)now.plusHours(1));
        String serializedData = serializer.serialize((Object)period);
        Assert.assertEquals((Object)"<org.joda.time.Period>PT1H</org.joda.time.Period>", (Object)serializedData);
        Assert.assertEquals((Object)period, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldAliasPrincipalAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(X500Principal.class);
        XStreamXmlSerializer serializer = builder.build();
        X500Principal principal = new X500Principal("CN=nl.bluelight");
        String serializedData = serializer.serialize((Object)principal);
        Assert.assertEquals((Object)"<principal>CN=nl.bluelight</principal>", (Object)serializedData);
        Assert.assertEquals((Object)principal, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertVersionedId() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(VersionedId.class);
        XStreamXmlSerializer serializer = builder.build();
        VersionedId versionedId = new VersionedId(1L, 2L);
        String serializedData = serializer.serialize((Object)versionedId);
        Assert.assertEquals((Object)"<versionedId>1:2</versionedId>", (Object)serializedData);
        Assert.assertEquals((Object)versionedId, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertX509ResourceCertificate() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(X509ResourceCertificate.class);
        XStreamXmlSerializer serializer = builder.build();
        X509ResourceCertificate resourceCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        String serializedData = serializer.serialize((Object)resourceCertificate);
        Assert.assertTrue((boolean)Pattern.matches("<commons\\.x509cert\\.X509ResourceCertificate>\\s*<encoded>[^<]+</encoded>\\s*</commons\\.x509cert\\.X509ResourceCertificate>", serializedData));
        Assert.assertEquals((Object)resourceCertificate, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertManifestCms() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(ManifestCms.class);
        XStreamXmlSerializer serializer = builder.build();
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        String serializedData = serializer.serialize((Object)manifestCms);
        Assert.assertTrue((boolean)Pattern.matches("<commons\\.cms\\.manifest\\.ManifestCms>\\s*<encoded>[^<]+</encoded>\\s*</commons\\.cms\\.manifest\\.ManifestCms>", serializedData));
        Assert.assertEquals((Object)manifestCms, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertRoaCms() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(RoaCms.class);
        XStreamXmlSerializer serializer = builder.build();
        RoaCms roaCms = RoaCmsTest.getRoaCms();
        String serializedData = serializer.serialize((Object)roaCms);
        Assert.assertTrue((boolean)Pattern.matches("<commons\\.cms\\.roa\\.RoaCms>\\s*<encoded>[^<]+</encoded>\\s*</commons\\.cms\\.roa\\.RoaCms>", serializedData));
        Assert.assertEquals((Object)roaCms, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldIgnoreUnknownElements() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(String.class);
        XStreamXmlSerializer serializer = builder.build();
        String deserializedData = (String)serializer.deserialize("<string>sample string</string><foo/>");
        Assert.assertEquals((Object)"sample string", (Object)deserializedData);
    }

    @Test
    public void shouldAliasPackage() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(SerializeMe.class);
        builder.withAliasPackage("test-alias", SerializeMe.class.getPackage().getName());
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new SerializeMe());
        Assert.assertEquals((Object)"<test-alias.XStreamXmlSerializerBuilderTest_-SerializeMe/>", (Object)serializedData);
    }

    private static class SerializeMe {
        private SerializeMe() {
        }
    }
}

