/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.error;

import java.io.IOException;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.error.NotPerformedError;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayload;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayloadSerializerBuilder;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class RequestNotPerformedResponsePayloadBuilderTest {
    private static final String TEST_ERROR_DESCRIPTION = "Something went wrong";
    private static final NotPerformedError TEST_ERROR = NotPerformedError.INTERNAL_SERVER_ERROR;
    private static final XStreamXmlSerializer<RequestNotPerformedResponsePayload> SERIALIZER = new RequestNotPerformedResponsePayloadSerializerBuilder().build();
    public static RequestNotPerformedResponsePayload NOT_PERFORMED_PAYLOAD = RequestNotPerformedResponsePayloadBuilderTest.createRequestNotPerformedResponsePayload();

    public static RequestNotPerformedResponsePayload createRequestNotPerformedResponsePayload() {
        RequestNotPerformedResponsePayloadBuilder builder = new RequestNotPerformedResponsePayloadBuilder();
        builder.withError(TEST_ERROR);
        builder.withDescription(TEST_ERROR_DESCRIPTION);
        return builder.build();
    }

    @Test
    public void shouldBuildValidListResponsePayload() throws Exception {
        Assert.assertEquals((Object)"sender", (Object)NOT_PERFORMED_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)NOT_PERFORMED_PAYLOAD.getRecipient());
        Assert.assertEquals((Object)TEST_ERROR, (Object)NOT_PERFORMED_PAYLOAD.getStatus());
        Assert.assertEquals((Object)TEST_ERROR_DESCRIPTION, (Object)NOT_PERFORMED_PAYLOAD.getDescription());
    }

    @Test
    public void shouldProduceXmlConformDraft() {
        String actualXml = SERIALIZER.serialize((Object)NOT_PERFORMED_PAYLOAD);
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\" version=\"1\" sender=\"sender\" recipient=\"recipient\" type=\"error_response\">\n  <status>" + TEST_ERROR.getErrorCode() + "</status>" + "\n" + "  <description xml:lang=\"en-US\">" + TEST_ERROR_DESCRIPTION + "</description>" + "\n" + "</message>";
        Assert.assertEquals((Object)expectedXml, (Object)actualXml);
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)NOT_PERFORMED_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

