/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.interop;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectValidator;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentity;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentitySerializer;
import net.ripe.rpki.commons.provisioning.identity.ParentIdentity;
import net.ripe.rpki.commons.provisioning.identity.ParentIdentitySerializer;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayload;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParser;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParserException;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessIscUpdownPdusTest {
    private static final String PATH_TO_TEST_PDUS = "src/test/resources/isc-interop-updown";

    @Test
    public void shouldParseCertificateIssuanceRequest() throws IOException, RpkiCaCertificateRequestParserException {
        byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/isc-interop-updown/pdu.200.der"));
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("cms", encoded);
        ValidationResult validationResult = parser.getValidationResult();
        for (ValidationCheck check : validationResult.getFailures(new ValidationLocation("cms"))) {
            System.err.println("Failure: " + check);
        }
        ProvisioningCmsObject provisioningCmsObject = parser.getProvisioningCmsObject();
        CertificateIssuanceRequestPayload payload = (CertificateIssuanceRequestPayload)provisioningCmsObject.getPayload();
        PKCS10CertificationRequest certificateRequest = payload.getRequestElement().getCertificateRequest();
        RpkiCaCertificateRequestParser rpkiCaCertificateRequestParser = new RpkiCaCertificateRequestParser(certificateRequest);
        Assert.assertNotNull((Object)rpkiCaCertificateRequestParser.getCaRepositoryUri());
        Assert.assertNotNull((Object)rpkiCaCertificateRequestParser.getManifestUri());
        Assert.assertNotNull((Object)rpkiCaCertificateRequestParser.getPublicKey());
    }

    @Test
    public void shouldReadIscChildIdentityXml() throws IOException {
        ProvisioningIdentityCertificate childCert = this.extractCarolIdentityCert();
        Assert.assertNotNull((Object)childCert);
    }

    @Test
    public void shouldReadIscIssuerXml() throws IOException {
        String parentXml = FileUtils.readFileToString((File)new File("src/test/resources/isc-interop-updown/issuer-alice-child-bob-parent.xml"), (String)"UTF-8");
        ParentIdentitySerializer serializer = new ParentIdentitySerializer();
        ParentIdentity parentId = serializer.deserialize(parentXml);
        Assert.assertNotNull((Object)parentId);
    }

    public ProvisioningIdentityCertificate extractCarolIdentityCert() throws IOException {
        String childIdXml = FileUtils.readFileToString((File)new File("src/test/resources/isc-interop-updown/carol-child-id.xml"), (String)"UTF-8");
        ChildIdentitySerializer serializer = new ChildIdentitySerializer();
        ChildIdentity childId = serializer.deserialize(childIdXml);
        ProvisioningIdentityCertificate childCert = childId.getIdentityCertificate();
        return childCert;
    }

    @Test
    public void shouldValidateRequest() throws IOException {
        byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/isc-interop-updown/pdu.200.der"));
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("cms", encoded);
        ProvisioningCmsObject provisioningCmsObject = parser.getProvisioningCmsObject();
        ProvisioningIdentityCertificate childCert = this.extractCarolIdentityCert();
        ProvisioningCmsObjectValidator validator = new ProvisioningCmsObjectValidator(new ValidationOptions(), provisioningCmsObject, childCert);
        ValidationResult result = new ValidationResult();
        validator.validate(result);
        List failures = result.getFailuresForAllLocations();
        Assert.assertEquals((long)3L, (long)failures.size());
        failures.contains(new ValidationCheck(ValidationStatus.ERROR, "cert.not.valid.after", new String[]{"2012-06-30T04:08:03.000Z"}));
        failures.contains(new ValidationCheck(ValidationStatus.ERROR, "crl.next.update.before.now", new String[]{"2012-06-30T04:07:24.000Z"}));
        failures.contains(new ValidationCheck(ValidationStatus.ERROR, "cert.not.valid.after", new String[]{"2012-06-30T04:07:24.000Z"}));
    }

    @Test
    public void shouldParseAllIscUpDownMessages() throws IOException {
        String[] Files;
        for (String fileName : Files = new String[]{"pdu.170.der", "pdu.171.der", "pdu.172.der", "pdu.173.der", "pdu.180.der", "pdu.183.der", "pdu.184.der", "pdu.189.der", "pdu.196.der", "pdu.199.der", "pdu.200.der", "pdu.205.der"}) {
            byte[] encoded = FileUtils.readFileToByteArray((File)new File("src/test/resources/isc-interop-updown/" + fileName));
            ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
            parser.parseCms("cms", encoded);
            Assert.assertTrue((String)("Error parsing file: " + fileName + " and giving up!"), (!parser.getValidationResult().hasFailures() ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldParseRpkidParentResponseXml() throws IOException {
        String xml = FileUtils.readFileToString((File)new File("src/test/resources/isc-interop-updown/rpkid-parent-response.xml"), (String)"UTF-8");
        ParentIdentitySerializer serializer = new ParentIdentitySerializer();
        ParentIdentity parentId = serializer.deserialize(xml);
        Assert.assertNotNull((Object)parentId);
    }

    @Test
    public void shouldParseRpkidMessageFromDeutscheTelekom() throws IOException {
        String[] Files;
        for (String fileName : Files = new String[]{"dtag-outbound-1.der", "dtag-outbound-9.der"}) {
            String base64Encoded = FileUtils.readFileToString((File)new File("src/test/resources/isc-interop-updown/" + fileName));
            byte[] encoded = Base64.decodeBase64((String)base64Encoded);
            ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
            parser.parseCms("cms", encoded);
            ValidationResult validationResult = parser.getValidationResult();
            Assert.assertTrue((String)("Error parsing file: " + fileName + " and giving up!"), (!validationResult.hasFailures() ? 1 : 0) != 0);
        }
    }

    private void dumpAsn1StructureToStdErr(byte[] encoded) {
        System.err.println(ASN1Dump.dumpAsString((Object)Asn1Util.decode((byte[])encoded)));
    }
}

