/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManifestCmsTest {
    private static final URI ROOT_CERTIFICATE_LOCATION = URI.create("rsync://foo.host/bar/bar.cer");
    private static final URI ROOT_SIA_MANIFEST_RSYNC_LOCATION = URI.create("rsync://foo.host/bar/manifest.mft");
    private static final URI ROOT_MANIFEST_CRL_LOCATION = URI.create("rsync://foo.host/bar/bar.crl");
    private static final IpResourceSet ROOT_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
    private static final KeyPair ROOT_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
    public static final KeyPair MANIFEST_KEY_PAIR = KeyPairFactoryTest.SECOND_TEST_KEY_PAIR;
    private static final X500Principal MANIFEST_DN = new X500Principal("CN=manifest");
    private static byte[] FOO_CONTENTS = new byte[]{97, 98, 99};
    private static byte[] BAR_CONTENTS = new byte[]{100, 101, 102};
    private static final DateTime THIS_UPDATE_TIME = new DateTime(2008, 9, 1, 22, 43, 29, 0, DateTimeZone.UTC);
    private static final DateTime NEXT_UPDATE_TIME = new DateTime(2008, 9, 2, 6, 43, 29, 0, DateTimeZone.UTC);
    private CrlLocator crlLocator;
    private ManifestCms subject;
    private X509ResourceCertificate rootCertificate;
    private static final ValidationOptions VALIDATION_OPTIONS = new ValidationOptions();

    public static ManifestCms getRootManifestCms() {
        ManifestCmsBuilder builder = ManifestCmsTest.getRootManifestBuilder();
        builder.addFile("foo1", FOO_CONTENTS);
        builder.addFile("BaR", BAR_CONTENTS);
        return builder.build(MANIFEST_KEY_PAIR.getPrivate());
    }

    @Before
    public void setUp() {
        DateTimeUtils.setCurrentMillisFixed((long)THIS_UPDATE_TIME.getMillis());
        this.rootCertificate = this.getRootResourceCertificate();
        this.crlLocator = (CrlLocator)EasyMock.createMock(CrlLocator.class);
        this.subject = ManifestCmsTest.getRootManifestCms();
    }

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void shouldVerifySignature() {
        Assert.assertTrue((boolean)this.subject.signedBy(this.subject.getCertificate()));
    }

    @Test
    public void shouldVerifyFileContents() {
        Assert.assertTrue((boolean)this.subject.verifyFileContents("foo1", FOO_CONTENTS));
        Assert.assertFalse((boolean)this.subject.verifyFileContents("BaR", FOO_CONTENTS));
        ManifestCms.FileContentSpecification spec = this.subject.getFileContentSpecification("BaR");
        Assert.assertTrue((boolean)spec.isSatisfiedBy(BAR_CONTENTS));
        Assert.assertFalse((boolean)spec.isSatisfiedBy(FOO_CONTENTS));
    }

    @Test
    public void shouldValidateManifestCms() {
        X509Crl crl = this.getRootCrl();
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources);
        ValidationResult result = new ValidationResult();
        EasyMock.expect((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).andReturn((Object)crl);
        EasyMock.replay((Object[])new Object[]{this.crlLocator});
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        EasyMock.verify((Object[])new Object[]{this.crlLocator});
        Assert.assertEquals((long)0L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertFalse((boolean)result.hasFailures());
    }

    @Test
    public void shouldNotValidateWithInvalidCrl() {
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources);
        final ValidationResult result = new ValidationResult();
        result.setLocation(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION));
        final ValidationLocation rootMftCrlValidationLocation = new ValidationLocation(ROOT_MANIFEST_CRL_LOCATION);
        EasyMock.expect((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).andAnswer((IAnswer)new IAnswer<X509Crl>(){

            public X509Crl answer() throws Throwable {
                Assert.assertEquals((Object)rootMftCrlValidationLocation, (Object)result.getCurrentLocation());
                result.rejectIfFalse(false, "cert.crl.signature", new String[0]);
                return null;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.crlLocator});
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        EasyMock.verify((Object[])new Object[]{this.crlLocator});
        Assert.assertTrue((boolean)result.hasFailureForCurrentLocation());
        Assert.assertEquals((Object)new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), (Object)result.getCurrentLocation());
        Assert.assertTrue((boolean)result.hasFailureForLocation(rootMftCrlValidationLocation));
        Assert.assertTrue((boolean)result.getAllValidationChecksForLocation(new ValidationLocation(ROOT_MANIFEST_CRL_LOCATION)).contains(new ValidationCheck(ValidationStatus.ERROR, "cert.crl.signature", new String[0])));
    }

    @Test
    public void shouldWarnWhenManifestIsStale() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.plusDays(1).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources);
        ValidationOptions options = new ValidationOptions();
        options.setMaxStaleDays(Integer.MAX_VALUE);
        ValidationResult result = new ValidationResult();
        EasyMock.expect((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).andReturn((Object)crl);
        EasyMock.replay((Object[])new Object[]{this.crlLocator});
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        EasyMock.verify((Object[])new Object[]{this.crlLocator});
        Assert.assertFalse((boolean)result.hasFailures());
        Assert.assertEquals((long)0L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.WARNING, "cert.not.valid.after", new String[]{NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "cert.not.valid.after"));
    }

    @Test
    public void shouldRejectWhenManifestIsTooStale() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.plusDays(1).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources);
        ValidationOptions options = new ValidationOptions();
        options.setMaxStaleDays(0);
        ValidationResult result = new ValidationResult();
        EasyMock.expect((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).andReturn((Object)crl);
        EasyMock.replay((Object[])new Object[]{this.crlLocator});
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        EasyMock.verify((Object[])new Object[]{this.crlLocator});
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "cert.not.valid.after", new String[]{NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "cert.not.valid.after"));
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "mf.past.next.update", new String[0]), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.past.next.update"));
    }

    @Test
    public void shouldWarnAboutInconsistentValidityTimes() {
        ManifestCms mft = ManifestCmsTest.getManifestWithInconsistentValidityTimes();
        X509Crl crl = this.getRootCrl();
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources);
        ValidationResult result = new ValidationResult();
        result.setLocation(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION));
        EasyMock.expect((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).andReturn((Object)crl);
        EasyMock.replay((Object[])new Object[]{this.crlLocator});
        mft.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        EasyMock.verify((Object[])new Object[]{this.crlLocator});
        Assert.assertEquals((long)0L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertFalse((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.WARNING, "mf.validity.inconsistent", new String[0]), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.validity.inconsistent"));
    }

    private X509Crl getRootCrl() {
        return this.getRootCrlBuilder().build(ROOT_KEY_PAIR.getPrivate());
    }

    private X509ResourceCertificate getRootResourceCertificate() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        builder.withResources(ROOT_RESOURCE_SET);
        builder.withPublicKey(ROOT_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        X509CertificateInformationAccessDescriptor[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, ROOT_SIA_MANIFEST_RSYNC_LOCATION)};
        builder.withSubjectInformationAccess(descriptors);
        builder.withCrlDistributionPoints(new URI[]{ROOT_MANIFEST_CRL_LOCATION});
        return builder.build();
    }

    private X509CrlBuilder getRootCrlBuilder() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(X509ResourceCertificateTest.TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withThisUpdateTime(new DateTime());
        builder.withNextUpdateTime(new DateTime().plusHours(8));
        builder.withNumber(BigInteger.TEN);
        builder.withAuthorityKeyIdentifier(ROOT_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private static ManifestCms getManifestWithInconsistentValidityTimes() {
        ManifestCmsBuilder builder = ManifestCmsTest.getRootManifestBuilder();
        builder.withCertificate(ManifestCmsTest.getManifestEEResourceCertificateBuilder(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME.plusDays(1))).build());
        return builder.build(MANIFEST_KEY_PAIR.getPrivate());
    }

    public static ManifestCmsBuilder getRootManifestBuilder() {
        return ManifestCmsTest.getRootManifestBuilder(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
    }

    public static ManifestCmsBuilder getRootManifestBuilder(ValidityPeriod validityPeriod) {
        ManifestCmsBuilder builder = new ManifestCmsBuilder();
        builder.withCertificate(ManifestCmsTest.getManifestEEResourceCertificateBuilder(validityPeriod).build());
        builder.withManifestNumber(BigInteger.valueOf(68L));
        builder.withThisUpdateTime(validityPeriod.getNotValidBefore()).withNextUpdateTime(validityPeriod.getNotValidAfter());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private static X509ResourceCertificateBuilder getManifestEEResourceCertificateBuilder(ValidityPeriod validityPeriod) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false);
        builder.withKeyUsage(128);
        builder.withSubjectDN(MANIFEST_DN);
        builder.withIssuerDN(X509ResourceCertificateTest.TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withSerial(BigInteger.ONE);
        builder.withPublicKey(MANIFEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(validityPeriod);
        builder.withCrlDistributionPoints(new URI[]{ROOT_MANIFEST_CRL_LOCATION});
        return builder;
    }
}

