/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectParserException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;

public final class CertificateRepositoryObjectFactory {
    private CertificateRepositoryObjectFactory() {
    }

    public static CertificateRepositoryObject createCertificateRepositoryObject(byte[] encoded, ValidationResult validationResult) {
        CertificateRepositoryObject result = CertificateRepositoryObjectFactory.tryParseAsX509ResourceCertificate(encoded, validationResult);
        if (result != null) {
            return result;
        }
        result = CertificateRepositoryObjectFactory.tryParseAsManifest(encoded, validationResult);
        if (result != null) {
            return result;
        }
        result = CertificateRepositoryObjectFactory.tryParseAsCrl(encoded);
        if (result != null) {
            return result;
        }
        result = CertificateRepositoryObjectFactory.tryParseAsROA(encoded, validationResult);
        if (result != null) {
            return result;
        }
        throw new CertificateRepositoryObjectParserException("Could not parse encoded object");
    }

    private static CertificateRepositoryObject tryParseAsCrl(byte[] encoded) {
        try {
            return X509Crl.parseDerEncoded(encoded);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static X509ResourceCertificate tryParseAsX509ResourceCertificate(byte[] encoded, ValidationResult validationResult) {
        ValidationResult temp = new ValidationResult();
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser(temp);
        parser.parse(validationResult.getCurrentLocation(), encoded);
        if (parser.isSuccess()) {
            validationResult.addAll(temp);
            return parser.getCertificate();
        }
        return null;
    }

    private static RoaCms tryParseAsROA(byte[] encoded, ValidationResult validationResult) {
        ValidationResult temp = new ValidationResult();
        RoaCmsParser parser = new RoaCmsParser(temp);
        parser.parse(validationResult.getCurrentLocation(), encoded);
        if (parser.isSuccess()) {
            validationResult.addAll(temp);
            return parser.getRoaCms();
        }
        return null;
    }

    private static ManifestCms tryParseAsManifest(byte[] encoded, ValidationResult validationResult) {
        ValidationResult temp = new ValidationResult();
        ManifestCmsParser parser = new ManifestCmsParser(temp);
        parser.parse(validationResult.getCurrentLocation(), encoded);
        if (parser.isSuccess()) {
            validationResult.addAll(temp);
            return parser.getManifestCms();
        }
        return null;
    }
}

