/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Map;
import java.util.TreeMap;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectBuilder;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationLocation;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.joda.time.DateTime;

public class ManifestCmsBuilder
extends RpkiSignedObjectBuilder {
    private X509ResourceCertificate certificate;
    private BigInteger number;
    private DateTime thisUpdateTime;
    private DateTime nextUpdateTime;
    private String signatureProvider = "SunRsaSign";
    private Map<String, byte[]> files = new TreeMap<String, byte[]>();

    public boolean containsFile(String fileName) {
        return this.files.containsKey(fileName);
    }

    public ManifestCmsBuilder withCertificate(X509ResourceCertificate signingCertificate) {
        this.certificate = signingCertificate;
        return this;
    }

    public ManifestCmsBuilder withManifestNumber(BigInteger number) {
        this.number = number;
        return this;
    }

    public ManifestCmsBuilder withThisUpdateTime(DateTime instant) {
        this.thisUpdateTime = instant;
        return this;
    }

    public ManifestCmsBuilder withNextUpdateTime(DateTime instant) {
        this.nextUpdateTime = instant;
        return this;
    }

    public ManifestCmsBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public ManifestCms build(PrivateKey privateKey) {
        ManifestCmsParser parser = new ManifestCmsParser();
        parser.parse(new ValidationLocation("<generated>"), this.generateCms(this.certificate.getCertificate(), privateKey, this.signatureProvider, new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.26"), this.encodeManifest()));
        return parser.getManifestCms();
    }

    public void addFile(String fileName, byte[] contents) {
        byte[] digestValue = ManifestCms.hashContents(contents);
        this.files.put(fileName, digestValue);
    }

    ASN1Encodable encodeFileAndHash(String fileName, byte[] hash) {
        ASN1Encodable[] seq = new ASN1Encodable[]{new DERIA5String(fileName, true), new DERBitString(hash)};
        return new DERSequence(seq);
    }

    ASN1Encodable encodeFileList() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        for (Map.Entry<String, byte[]> fileAndHash : this.files.entrySet()) {
            seq.add(this.encodeFileAndHash(fileAndHash.getKey(), fileAndHash.getValue()));
        }
        return new DERSequence(seq);
    }

    ASN1Encodable encodeManifest() {
        ASN1Encodable[] seq = new ASN1Encodable[]{new ASN1Integer(this.number), new ASN1GeneralizedTime(this.thisUpdateTime.toDate()), new ASN1GeneralizedTime(this.nextUpdateTime.toDate()), new ASN1ObjectIdentifier(ManifestCms.FILE_HASH_ALGORITHM), this.encodeFileList()};
        return new DERSequence(seq);
    }
}

