/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509;

import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateParser;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningIdentityCertificateParserTest {
    private ProvisioningIdentityCertificateParser subject;

    @Before
    public void setUp() {
        this.subject = new ProvisioningIdentityCertificateParser();
    }

    @Test
    public void shouldParseValidObject() {
        this.subject.parse("placeholder location", ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT.getEncoded());
        Assert.assertEquals((Object)ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT, (Object)this.subject.getCertificate());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnInvalidObject() {
        this.subject.parse("placeholder location", new byte[]{0});
        ValidationResult validationResult = this.subject.getValidationResult();
        Assert.assertTrue((boolean)validationResult.hasFailures());
        Assert.assertEquals((long)1L, (long)validationResult.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)"cert.parsed", (Object)((ValidationCheck)validationResult.getFailuresForCurrentLocation().iterator().next()).getKey());
        this.subject.getCertificate();
    }
}

